import * as Discord from "discord.js";
import "dotenv/config";
import { init } from "./init";
import path from "path";
import fs from "fs";
import { guild_id, User_regist } from "./type";
import { user_regist } from "./client/command/registration";
import { messageCreate } from "./client/dynamic/message";
import { voiceState } from "./client/dynamic/voice";
const { Guilds, GuildMessages, MessageContent, GuildMessageReactions, GuildMembers, GuildVoiceStates, GuildMessageTyping } = Discord.GatewayIntentBits;
const { Message, Channel, Reaction, GuildMember } = Discord.Partials;
const client = new Discord.Client({ 
    intents: [Guilds, GuildMessages, MessageContent, GuildMembers, GuildVoiceStates, GuildMessageTyping],
    partials: [Message, Channel, GuildMember ],
});
export const reg_db_path = path.join(__dirname, "../db/regist.json");
export const userLeveldb_path = path.join(__dirname, "../db/userLevel.json");
export var meeting_message:string;

const bot = init();
client.once("ready", () => {
    client.guilds.cache.forEach((guild) => {
        bot.setting(guild.id);
    });
    const reg = JSON.parse(fs.readFileSync(reg_db_path).toString()) as [string, User_regist][];
    reg.forEach((value) => {
        user_regist.set(value[0], value[1]);
    });

    meeting_init();
    console.log(client.user?.tag + " 봇 준비 완료");
});

process.on("uncaughtException", (err) => {
    console.error(err);

    const stackLines = err.stack?.split("\n");
    if(!stackLines) return;
    const errorSource = stackLines[1].trim();
    if(errorSource.includes("axios.cjs")) {
        process.exit(1);
    }
});

async function meeting_init() {
    const guild = await client.guilds.fetch(guild_id);
    const channel = await guild.channels.fetch("1293453821812674560") as Discord.TextChannel;
    const message = await channel.messages.fetch(meeting_message);
    const embed = new Discord.EmbedBuilder()
    .setTitle("회의 불참사유")
    .setDescription("회의 불참사유를 작성해주세요")
    .setColor("#FF0000");

    const row = new Discord.ActionRowBuilder<Discord.ButtonBuilder>();
    row.addComponents(
        new Discord.ButtonBuilder()
        .setCustomId("meeting_reason")
        .setLabel("회의 불참사유")
        .setStyle(Discord.ButtonStyle.Premium)
        .setEmoji("🚫")
    );

    // await channel.send({ embeds: [embed], components: [row] });
}

client.on("interactionCreate", (inte) => bot.run(inte));
client.on("messageCreate", (message) => messageCreate(message));
client.on("voiceStateUpdate", (oldState, newState) => voiceState(oldState, newState));

client.login(process.env.TOKEN);