import { DiscordBot } from "./setting";
import { GoogleSpreadsheet } from "google-spreadsheet";
import { JWT } from "google-auth-library";
import GoogleSheet from 'public-google-sheets-parser';
import Tetris from "./client/game/tetris";
import Spin from "./client/command/spin";
import Point from "./client/command/point";
import Admin from "./client/command/admin";
import Level from "./client/command/level";
import Registration from "./client/command/registration";
import Rename from "./client/command/rename";
import Fishing from "./client/game/fishing";
export var get_doc:GoogleSheet;
export var doc:GoogleSpreadsheet;

export function init() {
    const auth_bot = new JWT({
        email: process.env.EMAIL_SHEET,
        key: process.env.PRIVATE_KEY_SHEET as string,
        scopes: ['https://www.googleapis.com/auth/spreadsheets']
    });
    doc = new GoogleSpreadsheet((process.env.ID_SEET as string), auth_bot);
    get_doc = new GoogleSheet((process.env.ID_SEET as string));

    const bot = new DiscordBot();
    bot.init(new Tetris());
    bot.init(new Spin());
    bot.init(new Point());
    bot.init(new Admin());
    bot.init(new Level());
    bot.init(new Registration());
    bot.init(new Rename());
    bot.init(new Fishing());

    return bot;
}

export var role_rank:{ [key in string]:string } = {
    " 甲 갑 ": "갑",
    " 乙 을 ": "을",
    " 丙 병 ": "병",
    " 丁 정 ": "정",
    " 戊 무 ": "무",
    " 己 기 " : "기",
    " 庚 경 ": "경",
    " 辛 신 ": "신",
    " 壬 임 ": "임",
    " 癸 계 ": "계",
    "?": "알수없음"
}