import * as Discord from 'discord.js';
import { Command } from '../../../setting';
import { doc, get_doc } from '../../../init';
import { Inte, Member, mess_op, Sheet_fishing, Sheet_User } from '../../../type';
import { data_break, save_data, user_index, row_button, break_save, fishing_button, getCount } from './button';
import { fish, fish_price, fish_rank, fishing_rod, getData, position } from './env';

export default class Fishing implements Command {
    private is_fishing = new Map<string, { b:boolean, t:NodeJS.Timeout|undefined }>();
    private is_Move = new Map<string, NodeJS.Timeout>();
    private fishing_selling = new Map<string, string[]>();

    command() {
        return [
            new Discord.SlashCommandBuilder().setName("낚시게임").setDescription("낚시 게임을 시작합니다")
        ]
    }

    async run(inte:Inte) {
        let result = false;
        if(inte.isCommand()) {
            if(inte.commandName == "낚시게임") {
                result = true;
                const mess = await inte.reply("<a:load:1303002986359951410>");
                if(this.is_Move.get(inte.user.id)) {
                    await mess.edit("이동중입니다");
                    return result;
                }

                get_doc.setOption({ sheetId: process.env.S_FISHING });
                const data = await get_doc.parse() as Sheet_fishing[];
                const user = data.find((d) => d.user_id == inte.user.id);

                let img = position["바다"].url;
                if(user) {
                    img = position[user.position].url;
                }
                const member = inte.member as Member;

                const embed = new Discord.EmbedBuilder()
                .setAuthor({ iconURL: member.displayAvatarURL() ?? "https://res.ourgram.co.kr/discord/profile.png", name: inte.user.username })
                .setDescription(user?.position ?? "바다")
                .setImage(img)
                .setFooter({ iconURL: "https://cdn.discordapp.com/emojis/1285790003615498261.gif?size=128", text: (user?.coins ?? "0")+"원" })
                .setColor("#0000FF");

                const row = new Discord.ActionRowBuilder<Discord.StringSelectMenuBuilder>();
                row.addComponents(
                    new Discord.StringSelectMenuBuilder()
                    .setCustomId("fishing_game")
                    .setOptions([
                        { label: "낚시 하기", value: "1", emoji: "🎣" },
                        { label: "인벤토리", value: "2", emoji: "🎒" },
                        { label: "자리 이동", value: "3", emoji: "🚶" },
                        { label: "상점", value: "4", emoji: "🏪" },
                    ])
                );

                await mess.edit({ embeds: [embed], components: [row], content: "" });
                data_break.set(inte.user.id, []);
                save_data.set(inte.user.id, []);
                user_index.set(inte.user.id, 0);
                
                (data_break.get(inte.user.id) as mess_op)[0] = ({ embeds:[embed], components:[row] });

                if(!user) {
                    await doc.loadInfo();
                    const sheet = doc.sheetsByIndex[1];
                    await sheet.loadCells("A1:G"+(data.length+2));
                    const row = data.length + 1;
                    sheet.getCell(row, 0).value = inte.user.username;
                    sheet.getCell(row, 1).value = inte.user.id;
                    sheet.getCell(row, 2).value = 1;
                    sheet.getCell(row, 3).value = 0;
                    sheet.getCell(row, 4).value = "바다";
                    sheet.getCell(row, 6).value = "바다";
                    await sheet.saveUpdatedCells();
                }
            }
        }else if(inte.isButton()) {
            if(inte.customId == "fishGame_perv") {
                result = true;
                const id = inte.user.id;
                const index = (user_index.get(id) as number)-1;
                const mess = (data_break.get(id) as mess_op)[index];
                user_index.set(id, index);
                const is = this.is_fishing.get(inte.user.id);
                if(is?.b) clearTimeout(is.t);
                this.is_fishing.set(id, { b:false, t:undefined });
                await inte.update({
                    embeds:mess?.embeds,
                    components:mess?.components
                });
                (data_break.get(id) as mess_op)[index] = ({ embeds:mess?.embeds, components:mess?.components });
            }else if(inte.customId == "fishGame_next") {
                result = true;
                const id = inte.user.id;
                const index = (user_index.get(id) as number)+1;
                const mess = (data_break.get(id) as mess_op)[index];
                user_index.set(id, index);
                await inte.update({
                    embeds:mess?.embeds,
                    components:mess?.components
                });
            }else {
                result = await fishing_button(inte);
            }
        }else if(inte.isStringSelectMenu()) {
            result = await this.select(inte);
        }else if(inte.isModalSubmit()) {
            if(inte.customId == "fishing_selling") {
                const value = inte.components;
                let money = 0;
                const mess = await inte.deferUpdate();

                get_doc.setOption({ sheetId: process.env.S_FISHING });
                const list = await get_doc.parse() as Sheet_fishing[];
                const index = list.findIndex((d) => d.user_id == inte.user.id) + 1;
                const data = list.find((d) => d.user_id == inte.user.id);
                let fishArray = list[index-1].inventory?.split(",") as string[];
                const selling = this.fishing_selling.get(inte.user.id);
                for(let i=0; i < value.length; i++) {
                    const input = value[i];
                    const num = Number(input.components[0].value);
                    if(num) {
                        const name = selling?.at(i) as string;
                        const count = getCount(fishArray, name);
                        if(count >= num) {
                            fishArray = this.fish_remove(fishArray, name, count-num);
                            for(let i=0; i < num; i++) money += fish_price[fish[name].rank].price;
                        }else {
                            await mess.edit({content:"범위를 초과했습니다" });
                            return result;
                        }
                    }else {
                        await mess.edit({content:"숫자를 입력해 주세요"});
                        return result;
                    }
                }
                const embed = new Discord.EmbedBuilder()
                .setTitle("판매 완료")
                .setDescription("<a:coins:1303013786793414656> +"+money+"원")
                .setColor("#00FF00")
                .setImage("https://res.ourgram.co.kr/discord/fishing/selling.png");
            
                money += Number(data?.coins) ?? 0;
                await doc.loadInfo(true);
                const sheet = doc.sheetsByIndex[1];
                await sheet.loadCells("A1:G"+list.length+2);
                sheet.getCell(index, 3).value = money;
                sheet.getCell(index, 5).value = fishArray.toString();
                await sheet.saveUpdatedCells();
                
                await mess.edit({ content:"",embeds:[embed],components:[] });
            }else if(inte.customId == "fishing_selling_point") {
                const value = inte.components;
                let point = 0;
                const mess = await inte.deferUpdate();

                get_doc.setOption({ sheetId: process.env.S_FISHING });
                const list = await get_doc.parse() as Sheet_fishing[];
                const index = list.findIndex((d) => d.user_id == inte.user.id) + 1;
                const data = list.find((d) => d.user_id == inte.user.id);
                let fishArray = list[index-1].inventory?.split(",") as string[];
                const selling = this.fishing_selling.get(inte.user.id);
                for(let i=0; i < value.length; i++) {
                    const input = value[i];
                    const num = Number(input.components[0].value);
                    if(num) {
                        const name = selling?.at(i) as string;
                        const count = getCount(fishArray, name);
                        if(count >= num) {
                            fishArray = this.fish_remove(fishArray, name, count-num);
                            for(let i=0; i < num; i++) point += fish_price[fish[name].rank].point;
                        }else {
                            await mess.edit({content:"범위를 초과했습니다" });
                            return result;
                        }
                    }else {
                        await mess.edit({content:"숫자를 입력해 주세요"});
                        return result;
                    }
                }
                const embed = new Discord.EmbedBuilder()
                .setTitle("포인트 전환 완료")
                .setDescription("<a:point:1303013786793414656> +"+point+"포인트")
                .setColor("#00FF00")
                .setImage("https://res.ourgram.co.kr/discord/fishing/selling.png");

                get_doc.setOption({ sheetId: process.env.S_USER });
                const user = await get_doc.parse() as Sheet_User[];
                const user_data = user.find((d) => d.user_id == inte.user.id);
                const user_index = user.findIndex((d) => d.user_id == inte.user.id) + 1;
            
                point += user_data?.point ?? 0;
                await doc.loadInfo(true);
                const sheet = doc.sheetsByIndex[1];
                await sheet.loadCells("A1:G"+list.length+2);
                sheet.getCell(index, 5).value = fishArray.toString();
                await sheet.saveUpdatedCells();

                const sheet_2 = doc.sheetsByIndex[2];
                await sheet_2.loadCells("A1:G"+user.length+2);
                sheet_2.getCell(user_index, 2).value = point;
                await sheet_2.saveUpdatedCells();
                
                await mess.edit({ content:"",embeds:[embed],components:[] });
            }
        }
        return result;
    }

    async select(inte:Discord.StringSelectMenuInteraction) {
        let result = false;
        if(inte.customId == "fishing_game") {
            result = true;
            const username = inte.message.embeds[0].author?.name;
            if(username != inte.user.username) {
                await inte.reply({ content: "직접 `/낚시게임`를 치셔서 해주세요", ephemeral:true });
                return result;
            }
            const value = inte.values[0];
            const embed = inte.message.embeds[0];
            get_doc.setOption({ sheetId: process.env.S_FISHING });
            const data = await get_doc.parse() as Sheet_fishing[];
            const user = data.find((d) => d.user_id == inte.user.id);
            if(!user) {
                await inte.reply({ content: "오류 발생", ephemeral:true });
                return result;
            }
            break_save(inte.user.id, 1);

            if(value == "1") {
                if(this.is_fishing.get(inte.user.id)?.b) {
                    await inte.reply({ content: "이미 낚시 중입니다", ephemeral:true });
                    return result;
                }
                const rod_fish = fishing_rod.find((d) => d.id == user.fishing_rod);
                const time = position[user.position as string].time - (rod_fish?.time as number);
                const date = new Date(Date.now()+time);
                const timestamp = "<t:"+Math.floor(date.getTime()/1000)+":R>";

                const newEmbed = Discord.EmbedBuilder.from(embed);
                newEmbed.setImage("https://res.ourgram.co.kr/discord/fishing/load.gif")
                .setThumbnail(embed.image?.url as string)
                .setTitle(embed.description+"에서 낚시 중..")
                .setDescription("낚시중 "+timestamp+"에 잡힐거 같아요!")
                .setColor(null)
                .setTimestamp();

                const row = row_button("낚시 포기하고 돌아가기");
                const mess = await inte.update({ embeds: [newEmbed], components: [row] });
                const node:{ b:boolean, t:NodeJS.Timeout|undefined } = {
                    b:true,
                    t:undefined
                }

                node.t = setTimeout(async () => {
                    if(this.is_fishing.get(inte.user.id)?.b) {
                        const mess_result = await mess.edit({ content:"<a:load:1303002986359951410>", embeds: [], components: [] });
                        const embed_result = new Discord.EmbedBuilder();
                        const result = this.getFishing(user.position);
                        if(result.is) {
                            embed_result.setTitle("낚시 성공")
                            .setDescription("축하합니다! "+result.fish+"를 잡았어요! "+fish[result.fish].emoji)
                            .setImage("https://res.ourgram.co.kr/discord/fishing/success.gif")
                            .setColor("#00FF00")
                            .setTimestamp();
                            await doc.loadInfo();
                            const sheet = doc.sheetsByIndex[1];
                            await sheet.loadCells("A1:G"+(data.length+2));
                            const row = data.findIndex((d) => d.user_id == inte.user.id) + 1;

                            const innventory_fish = (sheet.getCell(row, 5).value as string|null ?? "").split(",");
                            innventory_fish.push(result.fish);
                            sheet.getCell(row, 5).value = innventory_fish.join(",");
                            await sheet.saveUpdatedCells();
                        }else {
                            embed_result.setTitle("낚시 실패")
                            .setDescription("아쉽게도 물고기가 도망쳤어요..")
                            .setImage("https://res.ourgram.co.kr/discord/fishing/fail.gif")
                            .setColor("#FF0000")
                            .setTimestamp();
                        }
                        await (await mess_result.edit({ embeds: [embed_result], components: [], content:"" })).reply(Discord.userMention(inte.user.id));
                        this.is_fishing.delete(inte.user.id);
                        user_index.delete(inte.user.id);
                        data_break.delete(inte.user.id);
                        save_data.delete(inte.user.id);
                    }
                }, time);
                this.is_fishing.set(inte.user.id, node);
            }else if(value == "2") {
                const mess = await inte.deferUpdate();
                const rod_fish = fishing_rod.find((d) => d.id == user.fishing_rod);
                const embed = new Discord.EmbedBuilder()
                .setTitle("인벤토리")
                .setThumbnail("https://res.ourgram.co.kr/discord/fishing/inventory.png")
                .setDescription("**현재 낚시대**: "+rod_fish?.name+"\n- 성능: -"+((rod_fish?.time as number)/1000)+"초\n- 행운 "+rod_fish?.weights+"배");
                const row = row_button("돌아가기");
                const data = await getData(inte.user.id);
                const fishArray = data.d.inventory?.split(",") as string[];

                let nextEmbed:Discord.EmbedBuilder|null = null;

                const nextRow = row_button("이전").addComponents(
                    new Discord.ButtonBuilder()
                    .setCustomId("fishGame_next")
                    .setLabel("다음")
                    .setEmoji("<a:next:1290228110498729994>")
                    .setStyle(Discord.ButtonStyle.Primary)
                );

                const fish_data = [...new Set(fishArray)];
                let i = 0, j = 1, is = true;
                for(const fis of fish_data) {
                    i++;
                    if(fis == '') continue;
                    if(is) {
                        embed.addFields({ name: `${fis} : ${getCount(fishArray, fis)}개`, value:fish[fis].emoji, inline:true });
                    }else {
                        nextEmbed?.addFields({ name: `${fis} : ${getCount(fishArray, fis)}개`, value:fish[fis].emoji, inline:true });
                    }

                    if(i >= 24 || fish_data.findIndex((d) => d == fis) == fish_data.length-1) {
                        i = 0;
                        if(!is && nextEmbed) {
                            j++;
                            break_save(inte.user.id, j);
                            (data_break.get(inte.user.id) as mess_op)[j] = ({ embeds:[nextEmbed], components:[nextRow] });
                        }
                        if(i >= 24) {
                            nextEmbed = new Discord.EmbedBuilder()
                            .setTitle("인벤토리")
                            .setThumbnail("https://res.ourgram.co.kr/discord/fishing/inventory.png");
                            is = false;
                        }
                    }
                }
                if(nextEmbed) {
                    row.addComponents(
                        new Discord.ButtonBuilder()
                        .setCustomId("fishGame_next")
                        .setLabel("다음")
                        .setEmoji("<a:next:1290228110498729994>")
                        .setStyle(Discord.ButtonStyle.Primary)
                    );
                }

                await mess.edit({embeds:[embed], components:[row]});
                user_index.set(inte.user.id, 1);
                (data_break.get(inte.user.id) as mess_op)[1] = ({ embeds:[embed], components:[row] });
            }else if(value == "3") {
                const embed = new Discord.EmbedBuilder()
                .setTitle("이동")
                .setDescription("자 어디로 대려라 줄까?!")
                .setColor("#0066FF")
                .setImage("https://res.ourgram.co.kr/discord/fishing/ship.gif");
                const user_data = await getData(inte.user.id);
                const row_select = new Discord.ActionRowBuilder<Discord.StringSelectMenuBuilder>();

                const row_btn = row_button("돌아가기");
                const select = new Discord.StringSelectMenuBuilder()
                .setCustomId("fishing_ship").setPlaceholder("이동할 곳을 선택해주세요");

                for(const data of Object.entries(position)) {
                    if(user_data.d.position == data[0]) continue;
                    if(user_data.d.ownership?.split(",").includes(data[0])) {
                        select.addOptions({ label:data[0], value: data[0] });
                    }else {
                        select.addOptions({ label:data[0] + " : 이동료 ( "+data[1].price+"원 )", value: data[0] });
                    }
                }
                row_select.addComponents(select);

                await inte.update({ embeds:[embed], components:[row_select, row_btn] });
                (data_break.get(inte.user.id) as mess_op)[1] = ({ embeds:[embed], components:[row_select] });
            }else if(value == "4") {
                const embed = new Discord.EmbedBuilder()
                .setTitle("상점")
                .setImage("https://res.ourgram.co.kr/discord/fishing/shop.png")
                .setColor("#FFFF00");

                const row = new Discord.ActionRowBuilder<Discord.ButtonBuilder>();
                row.addComponents(
                    new Discord.ButtonBuilder()
                    .setCustomId("shop_selling")
                    .setLabel("팔기")
                    .setEmoji("💵")
                    .setStyle(Discord.ButtonStyle.Primary),

                    new Discord.ButtonBuilder()
                    .setCustomId("shop_selling_point")
                    .setLabel("포인트 전환")
                    .setEmoji("💳")
                    .setStyle(Discord.ButtonStyle.Primary),

                    new Discord.ButtonBuilder()
                    .setCustomId("shop")
                    .setLabel("상품 구매")
                    .setEmoji("💍")
                    .setStyle(Discord.ButtonStyle.Primary)
                );
                const row_btn = row_button("낚시터로 돌아가기");

                await inte.update({ embeds:[embed], components:[row, row_btn] });
                (data_break.get(inte.user.id) as mess_op)[1] = ({ embeds:[embed], components:[row, row_btn] });
            }
        }else if(inte.customId == "fishing_count_intput" || inte.customId == "fishing_count_intput_2") {
            result = true;
            const value = inte.values;
            const modal = new Discord.ModalBuilder()
            .setTitle("판매 갯수")
            .setCustomId("fishing_selling");
            const data = await getData(inte.user.id);
            const arr = data.d.inventory?.split(",") as string[];

            let selling:string[] = [];
            for(const f of value) {
                const row = new Discord.ActionRowBuilder<Discord.TextInputBuilder>();
                row.addComponents(
                    new Discord.TextInputBuilder()
                    .setCustomId(f+"_sell")
                    .setLabel(f + " 갯수")
                    .setPlaceholder("현재 "+getCount(arr, f)+"마리 소유중")
                    .setStyle(Discord.TextInputStyle.Short)
                    .setRequired(true)
                );
                selling.push(f);
                modal.addComponents(row);
            }
            this.fishing_selling.set(inte.user.id, selling);

            await inte.showModal(modal);
        }else if(inte.customId == "fishing_count_intput_point" || inte.customId == "fishing_count_intput_point_2") {
            result = true;
            const value = inte.values;
            const modal = new Discord.ModalBuilder()
            .setTitle("포인트 전환")
            .setCustomId("fishing_selling_point");
            const data = await getData(inte.user.id);
            const arr = data.d.inventory?.split(",") as string[];

            let selling:string[] = [];
            for(const f of value) {
                const row = new Discord.ActionRowBuilder<Discord.TextInputBuilder>();
                row.addComponents(
                    new Discord.TextInputBuilder()
                    .setCustomId(f+"_sell")
                    .setLabel(f + " 갯수")
                    .setPlaceholder("현재 "+getCount(arr, f)+"마리 소유중")
                    .setStyle(Discord.TextInputStyle.Short)
                    .setRequired(true)
                );
                selling.push(f);
                modal.addComponents(row);
            }
            this.fishing_selling.set(inte.user.id, selling);

            await inte.showModal(modal);
        }else if(inte.customId == "shop_fishing_rod") {
            result = true;
            const name = inte.values[0];
            const mess = await inte.deferUpdate();
            const rod_fish = fishing_rod.find((d) => d.name == name);
            const data = await getData(inte.user.id);
            const coins = Number(data.d.coins)-(rod_fish?.price as number);
            if(coins < 0) {
                await inte.reply({content:"돈이 부족합니다", ephemeral:true});
                return result;
            }

            await doc.loadInfo();
            const sheet = doc.sheetsByIndex[1];
            await sheet.loadCells("A1:G"+data.length);
            sheet.getCell(data.row, 2).value = rod_fish?.id;
            sheet.getCell(data.row, 3).value = coins;
            await sheet.saveUpdatedCells();
            const embed = new Discord.EmbedBuilder()
            .setTitle("구매완료!")
            .setColor("#008000");

            await mess.edit({ embeds:[embed], components:[] });
        }else if(inte.customId == "fishing_ship") {
            result = true;
            const name = inte.values[0];
            const obj = Object.entries(position);
            const pos = obj.find(p => p[0] == name);
            const data = await getData(inte.user.id);
            const coins = Number(data.d.coins)-(pos?.[1].price as number);
            const is = data.d.ownership?.split(",").includes(name);
            if(!is) {
                if(coins < 0) {
                    await inte.reply({content:"돈이 부족합니다", ephemeral:true});
                    return result;
                }
            }

            const embed = new Discord.EmbedBuilder()
            .setTitle("이동중..")
            .setDescription("<a:load:1303002986359951410>")
            .setImage("https://res.ourgram.co.kr/discord/fishing/move.gif");
            const mess = await inte.update({ embeds:[embed], components:[] });

            await doc.loadInfo();
            const sheet = doc.sheetsByIndex[1];
            await sheet.loadCells("A1:G"+data.length);
            sheet.getCell(data.row, 4).value = name;
            if(!is) {
                sheet.getCell(data.row, 3).value = coins;
                sheet.getCell(data.row, 6).value += ","+name;
            }
            await sheet.saveUpdatedCells();

            const isMove = setTimeout(async () => {
                const embed = new Discord.EmbedBuilder()
                .setTitle("도착!!")
                .setDescription("이제 낚시를 시작해 볼까!")
                .setImage(pos?.[1].url as string);

                await mess.edit({ embeds:[embed] });
                this.is_Move.delete(inte.user.id);
            },3000);

            this.is_Move.set(inte.user.id, isMove);
        }
        return result;
    }

    getFishing(pos:string) {
        const result = {
            fish: "",
            is: false
        };
        const successRate = 0.7;
        result.is = Math.random() < successRate;
        
        if (result.is) {
            const rarityRate = Math.random() * 100;
            let rarity: fish_rank;
            
            if (rarityRate < 53) {
                rarity = "흔함";
            } else if (rarityRate < 53 + 35) {
                rarity = "희귀";
            } else if (rarityRate < 53 + 35 + 8) {
                rarity = "귀함";
            } else if (rarityRate < 53 + 35 + 8 + 4) {
                rarity = "전설";
            } else {
                rarity = "신화";
            }
            const p = position[pos];
            
            while(!p.fish.includes(result.fish)) {
                const fishList = Object.entries(fish).filter(([_, value]) => value.rank === rarity);
                const randomFish = fishList[Math.floor(Math.random() * fishList.length)];
                result.fish = randomFish[0];
            }
        }
        return result;
    }

    fish_remove(arr:string[], target:string, value:number) {
        let count = 0; 
        return arr.filter(item => {
            if (item != target) return true;
            if (count < value) {
                count++;
                return true;
            }
            return false;
        });
    }
}