import * as Discord from 'discord.js';
import { fish, fish_price, fishing_rod, getData } from './env';
import { mess_op, Sheet_User } from '../../../type';
import { get_doc } from '../../../init';
export const data_break:Map<string, mess_op> = new Map();
export const save_data:Map<string, mess_op> = new Map();
export const user_index:Map<string, number> = new Map();

export async function fishing_button(inte:Discord.ButtonInteraction) {
    let result = false;
    if(inte.customId == "shop_selling" || inte.customId == "shop_selling_point") {
        result = true;
        break_save(inte.user.id, 2);
        const mess = await inte.deferUpdate();

        const newEmbed = Discord.EmbedBuilder.from(inte.message.embeds[0])
        .setTitle("물고기 팔기")
        .setDescription("최대 5개 선택");
        
        const row = new Discord.ActionRowBuilder<Discord.StringSelectMenuBuilder>();
        const newRow = new Discord.ActionRowBuilder<Discord.StringSelectMenuBuilder>();
        const data = await getData(inte.user.id);
        const fihArray = data.d?.inventory?.split(",") as string[];
        const count:{ [key in string]: number }= {};
        fihArray.forEach((x) => { 
            count[x] = (count[x] || 0)+1; 
        });
        const fih = [...new Set(fihArray)];
        let max = fih.length;

        const select = new Discord.StringSelectMenuBuilder()
        .setCustomId("fishing_count_intput")
        .setPlaceholder("판매할 물고기를 선택해주세요")
        .setMinValues(1)
        .setMaxValues(max > 6 ? 5 : max-1);

        const newSelect = new Discord.StringSelectMenuBuilder()
        .setCustomId("fishing_count_intput_2")
        .setPlaceholder("판매할 물고기를 선택해주세요")
        .setMinValues(1)

        if(inte.customId == "shop_selling_point") {
            select.setCustomId("fishing_count_intput_point");
            newSelect.setCustomId("fishing_count_intput_2_point");
        }

        get_doc.setOption({ sheetId: process.env.S_USER });
        const list = await get_doc.parse() as Sheet_User[];
        const user = list.find((d) => d.user_id == inte.user.id);
        if(!user && inte.customId == "shop_selling_point") {
            await inte.editReply("먼저 /포인트확인 명령어를 입력해주세요");
            return result;
        }
        
        for(let i=0; i < max; i++) {
            const f = fih[i];
            if(!f && f == '') continue;
            if(inte.customId == "shop_selling_point") {
                if(i >= 24) {
                    newSelect.addOptions({
                        label: f + ` (${fish_price[fish[f].rank].point}포인트) ${count[f] ?? 0}개`,
                        value: f,
                        emoji: fish[f].emoji
                    });
                }else {
                    select.addOptions({
                        label: f + ` (${fish_price[fish[f].rank].point}포인트) ${count[f] ?? 0}개`,
                        value: f,
                        emoji: fish[f].emoji
                    });
                }
            }else {
                if(i >= 24) {
                    newSelect.addOptions({
                        label: f + ` (${fish_price[fish[f].rank].price}원) ${count[f] ?? 0}개`,
                        value: f,
                        emoji: fish[f].emoji
                    });
                }else {
                    select.addOptions({
                        label: f + ` (${fish_price[fish[f].rank].price}원) ${count[f] ?? 0}개`,
                        value: f,
                        emoji: fish[f].emoji
                    });
                }
            }
        }
        row.addComponents(select);
        if(max > 24) {
            newSelect.setMaxValues(max-24 > 6 ? 5 : max-25);
            newRow.addComponents(newSelect);
        }
        const row_btn = row_button("뒤로가기");

        if(newRow.components.length > 0) {
            await mess.edit({ embeds:[newEmbed], components:[row, newRow, row_btn] });
            (data_break.get(inte.user.id) as mess_op)[2] = ({ embeds:[newEmbed], components:[row, newRow, row_btn] });
        }else {
            await mess.edit({ embeds:[newEmbed], components:[row, row_btn] });
            (data_break.get(inte.user.id) as mess_op)[2] = ({ embeds:[newEmbed], components:[row, row_btn] });
        }
    }else if(inte.customId == "shop") {
        result = true;
        break_save(inte.user.id, 2);
        const mess = await inte.deferUpdate();
        const data = await getData(inte.user.id);
        const newEmbed = Discord.EmbedBuilder.from(inte.message.embeds[0])
        .setTitle("상품 구매")
        .setImage(null)
        .setThumbnail(inte.message.embeds[0].image?.url as string)
        .setAuthor({ iconURL: "https://cdn.discordapp.com/emojis/1285790003615498261.gif?size=128", name: (data.d.coins ?? "0")+"원" })

        const row = new Discord.ActionRowBuilder<Discord.StringSelectMenuBuilder>();
        const select = new Discord.StringSelectMenuBuilder()
        .setCustomId("shop_fishing_rod")
        .setPlaceholder("구매할 상품을 선택해주세요");

        let i = 0;
        for(const tools of fishing_rod) {
            select.addOptions({label:tools.name,value: tools.name});
            newEmbed.addFields([
                { name: tools.name, value: tools.price+"원 / 성능 -"+(tools.time/1000)+"초 / 행운 "+tools.weights+"배" }
            ]);
        }
        row.addComponents(select);
        const row_btn = row_button("뒤로가기");

        await mess.edit({ embeds:[newEmbed], components:[row, row_btn] });
        (data_break.get(inte.user.id) as mess_op)[2] = ({ embeds:[newEmbed], components:[row, row_btn] });
    }
    return result;
}

export function break_save(id:string, index:number) {
    user_index.set(id, index);
    const mess = (data_break.get(id) as mess_op)[index-1];
    (save_data.get(id) as mess_op)[index-1] = { embeds:mess?.embeds, components:mess?.components }
}

export function row_button(label:string):Discord.ActionRowBuilder<Discord.ButtonBuilder> {
    const row = new Discord.ActionRowBuilder<Discord.ButtonBuilder>();
    row.addComponents(
        new Discord.ButtonBuilder()
        .setLabel(label)
        .setCustomId("fishGame_perv")
        .setEmoji("<a:perv:1284847268884779068>")
        .setStyle(Discord.ButtonStyle.Secondary)
    );
    return row;
}

export function getCount(arr:string[], target:string) {
    let count = 0;
    for(let i=0; i < arr.length; i++) {
        if(arr[i] == target)  {
            count++;
        }
    }
    return count;
}