import * as Discord from 'discord.js';
import fs from 'fs';
import { doc, get_doc } from '../../../init';
import { Sheet_level } from '../../../type';
import { userLeveldb_path } from '../../../main';
export const userLevel_db = new Map<string, number>();
export const voice_LEVEL_UP_BASE = 380; // 1 레벨업에 필요한 기본 경험치량
const channel_exception = [
    "1289545147377258536","1289545147847147532","1289545143522951200","1289545142294020107","1289545123742482464"
];
const XP_PER_MINUTE = 10; // 분당 얻는 경험치
const LEVEL_UP_MULTIPLIER = 2; // 레벨업 배수

export async function levelVoice(oldState: Discord.VoiceState, newState: Discord.VoiceState) {
    if(!oldState.channelId && newState.channelId) {
        const channel = newState.client.channels.cache.get(newState.channelId) as Discord.VoiceChannel;
        if(channel_exception.includes(channel.parentId as string)) return;
        userLevel_db.set(newState.member?.id as string, Date.now());
        fs.writeFileSync(userLeveldb_path, JSON.stringify(Array.from(userLevel_db.entries())));
    }

    if(oldState.channelId && !newState.channelId) {
        const channel = oldState.client.channels.cache.get(oldState.channelId) as Discord.VoiceChannel;
        if(channel_exception.includes(channel.parentId as string)) return;
        await level_up(oldState);
        userLevel_db.delete(oldState.id);
        fs.writeFileSync(userLeveldb_path, JSON.stringify(Array.from(userLevel_db.entries())));
    }
}

async function level_up(oldState: Discord.VoiceState) {
    get_doc.setOption({ sheetId: process.env.S_LEVEL_VOICDE });
    let value = await get_doc.parse() as Sheet_level[];
    const userLevel = value.find((d) => d.user_id == oldState.id);

    await doc.loadInfo();
    const sheet = doc.sheetsByIndex[4];
    let row = value.findIndex((d) => d.user_id == oldState.id) + 1;
    await sheet.loadCells("A1:D"+value.length+2);
    if(!userLevel) {
        row = value.length + 1;
        sheet.getCell(row, 0).value = oldState.member?.user.username;
        sheet.getCell(row, 1).value = 1;
        sheet.getCell(row, 2).value = voice_LEVEL_UP_BASE+" / 0";
        sheet.getCell(row, 3).value = oldState.id;
    }
    const xp = userLevel?.xp || voice_LEVEL_UP_BASE+" / 0";
    const xpArr = xp.split("/");
    let LEVEL_UP_BASE = Number(xpArr[0]);

    const time = userLevel_db.get(oldState.id) as number;
    const duration = Date.now() - time;
    const minutes = Math.floor(duration / 60000) * XP_PER_MINUTE;
    
    const xpGained = minutes * XP_PER_MINUTE;
    let newXP = Number(xpArr[1]) + xpGained;
    let level = userLevel?.level || 1;
    if(newXP >= LEVEL_UP_BASE) {
        while(newXP >= LEVEL_UP_BASE) {
            newXP -= LEVEL_UP_BASE;
            LEVEL_UP_BASE *= (LEVEL_UP_MULTIPLIER+getPuls(level));
            level++;
        }
        sheet.getCell(row, 1).value = level;
        if(LEVEL_UP_BASE <= newXP) {
            newXP = 0;
        }
        sheet.getCell(row, 2).value = LEVEL_UP_BASE + " / " + newXP;

    }else if(newXP < LEVEL_UP_BASE) {
        sheet.getCell(row, 2).value = LEVEL_UP_BASE + " / " + newXP;
    }
    await sheet.saveUpdatedCells();
}

function getPuls(level:number) {
    let puls = 0;
    if(level >= 10) {
        puls=3;
    }else if(level >= 15) {
        puls=4;
    }else if(level >= 20) {
        puls=5;
    }else if(level >= 25) {
        puls=6;
    }
    return puls;
}