import * as Discord from 'discord.js';
import GIFEncoder from 'gifencoder';
import { createCanvas } from 'canvas';
import { Command } from '../../../setting';
import { spin_create } from './spin_create';
import { Inte } from '../../../type';

export default class Spin implements Command {
    duration:number = 5000;
    
    command() {
        return [
            new Discord.SlashCommandBuilder().setName("spin").setDescription("추첨 뽑기를 진행합니다")
            .addStringOption(option =>
                option.setName("candidate")
                .setDescription("뽑을 후보들을 적어주세요 ,로 구분")
                .setRequired(true)
            )
        ];
    }

    async run(inte:Inte) {
        var result = false;
        if(!inte.isCommand()) return false;

        if(inte.commandName == "spin") {
            result = true;
            var mess = await inte.reply("<a:load:1303002986359951410>");
            const value = inte.options.get("candidate")?.value?.toString();
            const candidates = value?.split(",") as string[];

            if(candidates.length < 2) {
                await mess.edit("2개 이상의 후보를 적어주세요");
            }else if(candidates) {
                const spin = await this.spin(candidates);
                const spin_gif = new Discord.AttachmentBuilder(spin.getGif(), { name: "spin.gif" });
                const result_png = new Discord.AttachmentBuilder(spin.getLastFrame(), { name: "result.png" });
                
                const embed = new Discord.EmbedBuilder()
                .setTitle("결과 추첨중..");
                const embed_2 = new Discord.EmbedBuilder()
                .setColor(spin.spin_color as any)
                .setTitle("최종 결과")
                .setDescription("추첨 결과!!: "+ spin.spin_result);
                
                var mess_2 = await mess.edit({
                    content: "",
                    embeds: [embed],
                    files: [spin_gif],
                });
                
                setTimeout(async () => {
                    mess_2 = await mess_2.edit({
                        embeds: [embed_2],
                        files: [],
                    });

                    await mess_2.edit({
                        embeds: [embed_2],
                        files: [result_png],
                    });
                }, this.duration+570);
            }else {
                await mess.edit("뽑을 후보를 적어주세요");
            }
        }
        return result;
    }

    async spin(candidates:string[]) {
        const result = Math.random() * ((360 * 8) - 360) + 360;
        const display_ms = 50;

        const width = 200;
        const height = 200;
        const encoder = new GIFEncoder(width, height);
        encoder.start();
        encoder.setRepeat(0);
        encoder.setDelay(display_ms);
        encoder.setQuality(10);
        encoder.setTransparent("#ffffff");

        const canvas = createCanvas(width, height);
        const ctx = canvas.getContext('2d');

        const spin_wheel = spin_create(candidates, canvas, ctx as any , result, this.duration / display_ms);

        for(let i = 0; i < this.duration / display_ms; i++) {
            spin_wheel.rotate(i);
            encoder.addFrame(ctx as any);
        }

        encoder.finish();
        const spin_result = spin_wheel.getOptionByStep(this.duration / display_ms);
        return {
            getGif: () => encoder.out.getData(),
            getLastFrame: () => canvas.toBuffer(),
            spin_result: spin_result.option,
            spin_color: spin_result.color
        };
    }
}