import * as Discord from "discord.js";
import { Command } from '../../setting';
import { Inte, Member } from "../../type";

export default class Rename implements Command {
    private channel_id = "1300109434672123925";

    command() {
        return [
            new Discord.SlashCommandBuilder().setName("별명변경").setDescription("별명을 변경합니다.")
            .addStringOption(option =>
                option.setName("별명")
                .setDescription("변경할 별명을 입력해주세요.")
                .setRequired(true)
            )
        ]
    }

    async run(inte:Inte) {
        let result = false;
        if(inte.isCommand()) {
            if(inte.commandName === "별명변경") {
                result = true;
                if(inte.channelId == this.channel_id) {
                    const rename = inte.options.get("별명")?.value as string;
                    if(rename.length <= 8) {
                        const member = inte.member as Member;
                        const rank = member.nickname?.match(/『(.*?)』/);
                        if(rank) {
                            await inte.reply("별명이"+member.nickname?.replace(rank[0], "")+"에서 "+rename+"로 변경되었습니다.");
                            await member.setNickname(rank[0] +" "+ rename);
                        }
                    }else {
                        await inte.reply({
                            content: "별명은 8글자 이하로 입력해주세요.",
                            ephemeral: true
                        });
                    }
                }else {
                    await inte.reply({
                        content: "별명변경은 "+Discord.channelMention(this.channel_id)+"에서만 가능합니다.",
                        ephemeral: true
                    });
                }
            }
        }
        return result;
    }
}