import * as Discord from 'discord.js';
import { Command } from "../../setting";
import { reg_db_path } from '../../main';
import fs from 'fs';
import { Inte, User_regist } from '../../type';
export const user_regist: Map<string, User_regist> = new Map();

export default class Registration implements Command {

    command() {
        return [
            new Discord.SlashCommandBuilder().setName("자기소개").setDescription("우리 서버의 패밀리가 되고 싶다면 자기소개를 해주세요")
            .addStringOption(option =>
                option.setName("이름")
                .setDescription("사용자 이름")
                .setRequired(true)
            ).addStringOption(option =>
                option.setName("나이")
                .setDescription("나이 연도로 적어주세요")
                .addChoices([
                    { name: "11년", value:"11" },
                    { name: "10년", value:"10" },
                    { name: "09년", value:"09" },
                    { name: "08년", value:"08" },
                    { name: "07년", value:"07" },
                    { name: "06년", value:"06" },
                    { name: "05년", value:"05" },
                    { name: "04년", value:"04" },
                    { name: "03년", value:"03" },
                    { name: "02년", value:"02" },
                    { name: "01년", value:"01" },
                    { name: "00년", value:"00" },
                    { name: "99년", value:"99" },
                    { name: "98년", value:"98" },
                ]).setRequired(true)
            ).addStringOption(option =>
                option.setName("성별")
                .setDescription("자신의 성별")
                .addChoices([
                    { name: "남성", value: "남" },
                    { name: "여성", value: "여" }
                ]).setRequired(true)
            ).addStringOption(option =>
                option.setName("경로")
                .setDescription("들어온 경로를 입력해주세요") 
                .addChoices([
                    { name: "지인 초대", value: "지인 초대" },
                    { name: "부계", value: "부계" },
                    { name: "재입장", value: "재입장" }
                ]).setRequired(true)
            ).addStringOption(option =>
                option.setName("지인_초대")
                .setDescription("초대 받은 경우 초대 받은 사람의 이름을 적어주세요")
            )
        ]
    }

    async run(inte:Inte) {
        let result = false;
        if(inte.isCommand()) {
            if(inte.commandName == "자기소개") {
                result = true;
                const name = inte.options.get("이름")?.value as string;
                const age = inte.options.get("나이")?.value as string;
                const gender = inte.options.get("성별")?.value as string;
                const path = inte.options.get("경로")?.value as string;
                const invite = inte.options.get("지인_초대")?.value as string | null;

                if(!invite && path == "지인 초대") {
                    await inte.reply({
                        content:"초대 받은 경우 초대 받은 사람의 이름을 적어주세요",
                        ephemeral:true
                    });
                    return result;
                }

                if(isNaN(Number(age))) {
                    await inte.reply({
                        content:"나이는 숫자로 입력해주세요",
                        ephemeral:true
                    });
                    return result;
                }
                var year = "20"
                if(age[0] == "9") {
                    year = "19";
                }
                year += age;
                const age_now = (new Date().getFullYear() - Number(year))+1;
                user_regist.set(inte.user.id, {
                    name: name,
                    age: age_now,
                    gender: gender,
                    path: path,
                    invite: invite ? invite : null
                });

                const embed = new Discord.EmbedBuilder()
                .setTitle("자기소개 완료")
                .setImage(inte.user.avatarURL())
                .setDescription("승인이 될 때까지 기다려주세요")

                inte.reply({embeds:[embed]});
                const channel = inte.guild?.channels.cache.get("1303370858634543236") as Discord.TextChannel;

                const embed_2 = new Discord.EmbedBuilder()
                .setTitle("새 유저 "+inte.user.username+ "님이 서버에 자기소개를 마치셨습니다")
                .setDescription(inte.user.id)
                .setImage(inte.user.avatarURL())
                .setFields([
                    { name: "이름", value: name, inline:true },
                    { name: "나이", value: age_now+"세", inline:true },
                    { name: "성별", value: gender, inline:true },
                    { name: "경로", value: path, inline:true },
                    { name: "초대한 사람", value: invite ? invite : "없음", inline:true }
                ]);

                const row = new Discord.ActionRowBuilder<Discord.ButtonBuilder>();
                row.addComponents(
                    new Discord.ButtonBuilder()
                    .setCustomId("reg_accept")
                    .setLabel("수락")
                    .setStyle(Discord.ButtonStyle.Success)
                    .setEmoji("✅"),

                    new Discord.ButtonBuilder()
                    .setCustomId("reg_reject")
                    .setLabel("거절")
                    .setStyle(Discord.ButtonStyle.Danger)
                    .setEmoji("❌")
                );

                await channel.send({embeds:[embed_2], components:[row]});
                fs.writeFileSync(reg_db_path, JSON.stringify(Array.from(user_regist.entries())));
            }
        }else if(inte.isButton()) {
            if(inte.customId == "reg_accept") {
                result = true;
                const user_id = inte.message.embeds[0].description as string;
                const user = inte.guild?.members.cache.get(user_id);
                const user_reg = user_regist.get(user_id);

                const name = user_reg?.name as string;
                const age = user_reg?.age as number;
                const gender = user_reg?.gender as string;
                const path = user_reg?.path as string;
                const invite = user_reg?.invite as string | null;

                const embed = new Discord.EmbedBuilder()
                .setTitle("뉴페 기록")
                .setColor("#00FF00")
                .setAuthor({ name: "안내원: "+inte.user.username, iconURL: inte.user.avatarURL() as string })
                .setThumbnail(user?.user.avatarURL() as string)
                .setFields([
                    { name: "이름", value: name, inline:true },
                    { name: "나이", value: age+"세", inline:true },
                    { name: "성별", value: gender, inline:true },
                    { name: "경로", value: path, inline:true },
                    { name: "초대한 사람", value: invite ? invite : "없음", inline:true }
                ]);

                await inte.update({embeds:[embed], components:[]});

                await user?.setNickname("『 견습생 』  " + name);
                if(age <= 19) {
                    await user?.roles.add("1284117405295185961"); // 10대
                }else if(age <= 29) {
                    await user?.roles.add("1284117560329109554"); // 20대
                }

                if(gender == "남") {
                    await user?.roles.add("1284128158068510785"); // 남성
                }else if(gender == "여") {
                    await user?.roles.add("1284133420246499368"); // 여성
                }
                await user?.roles.add("1283799164030812294"); // 팸원
                await user?.roles.add("1297436058325352468"); // 아기참새
                await user?.roles.remove("1284078948602609684"); // 미확인 제거

                user_regist.delete(user_id);
                fs.writeFileSync(reg_db_path, JSON.stringify(Array.from(user_regist.entries())));

                const embed_hellow = new Discord.EmbedBuilder()
                .setDescription(`
## **❝ 참새패밀리 ❞ 에 입장 하셨습니다 <a:e_3:1284737800985514058>  **

︵‿︵‿୨ <:BEA990C7C8404A39A8511ACA0E59D7EA:1300463148922437632>   ୧︵‿︵‿

**<a:e_1:1284682346938896487>   다들 반갑게 맞이해주세요 ∿ **

<:e_5:1284738048285872269>  https://discord.com/channels/1283794554952093726/1293462542542307359 https://discord.com/channels/1283794554952093726/1283820909584449668 
두 채널을 꼭 읽어주세요 .ᐟ

<a:e_3:1284737617400692747> 서버 적응이 어려우시다면 <@&1300079721794502738> 을 
멘션해주세요 .ᐟ

<a:e_2:1284683094854471703>  건의 & 문의 사항이 생긴다면 ⁠
<#1284120043352887327> 에 남겨주세요 .ᐟ

︵‿︵‿୨ <:BEA990C7C8404A39A8511ACA0E59D7EA:1300463148922437632>   ୧︵‿︵‿`);

                const channel = inte.guild?.channels.cache.get("1283822331462025328") as Discord.TextChannel;
                await channel.send({embeds:[embed_hellow], content: "@here  "+Discord.userMention(user_id)});
            }else if(inte.customId == "reg_reject") {
                result = true;
                const user_id = inte.message.embeds[0].description as string;
                const user_reg = user_regist.get(user_id);
                const user = inte.guild?.members.cache.get(user_id);

                const embed = new Discord.EmbedBuilder()
                .setTitle("뉴페 거절")
                .setColor("#FF0000")
                .setAuthor({ name: "안내원: "+inte.user.username, iconURL: inte.user.avatarURL() as string })
                .setThumbnail(user?.user.avatarURL() as string)
                .setFields([
                    { name: "이름", value: user_reg?.name as string, inline:true },
                    { name: "나이", value: user_reg?.age+"세", inline:true },
                    { name: "성별", value: user_reg?.gender as string, inline:true },
                    { name: "경로", value: user_reg?.path as string, inline:true },
                    { name: "초대한 사람", value: user_reg?.invite ? user_reg?.invite : "없음", inline:true }
                ]);

                await inte.update({embeds:[embed], components:[]});
                user_regist.delete(user_id);
                fs.writeFileSync(reg_db_path, JSON.stringify(Array.from(user_regist.entries())));
            }
        }
        return result;
    }
}