import * as Discord from "discord.js";
import { Command } from "../../setting";
import { Inte, Member, Sheet_User } from "../../type";
import { doc, get_doc, role_rank } from "../../init";

export default class Point implements Command {
    private channel_id = "1302432209369567274";

    command() {
        return [
            new Discord.SlashCommandBuilder().setName("포인트_확인").setDescription("포인트를 확인합니다"),

            new Discord.SlashCommandBuilder().setName("포인트_추가").setDescription("포인트를 추가합니다")
            .addUserOption(option =>
                option.setName("유저")
                .setDescription("포인트를 추가할 유저를 선택해주세요")
                .setRequired(true)
            ).addNumberOption(option =>
                option.setName("포인트")
                .setDescription("추가할 포인트를 입력해주세요")
                .setRequired(true)
            ).setDefaultMemberPermissions(Discord.PermissionFlagsBits.Administrator),

            new Discord.SlashCommandBuilder().setName("포인트_차감").setDescription("포인트를 차감합니다")
            .addUserOption(option =>
                option.setName("유저")
                .setDescription("포인트를 차감할 유저를 선택해주세요")
                .setRequired(true)
            ).addNumberOption(option =>
                option.setName("포인트")
                .setDescription("차감할 포인트를 입력해주세요")
                .setRequired(true)
            ).setDefaultMemberPermissions(Discord.PermissionFlagsBits.Administrator)
        ]
    }

    async run(inte:Inte) {
        let result = false;
        if(inte.isCommand()) {
            if(inte.commandName == "포인트_확인") {
                result = true;
                if(inte.channelId == this.channel_id) {
                    const mess = await inte.reply("<a:load:1303002986359951410>");
                    
                    get_doc.setOption({ sheetId: process.env.S_USER });
                    const list = await get_doc.parse() as Sheet_User[];
                    const index = list.findIndex((d) => d.user_id == inte.user.id) + 1;
                    const member = inte.member as Member;
                    if(index == 0) {
                        const embed = new Discord.EmbedBuilder()
                        .setAuthor({ name: inte.user.username, iconURL: member.displayAvatarURL() as string })
                        .setTitle("포인트 확인")
                        .setDescription("- <:point:1303014441851420752> : 0");
                        const rank = (inte.member as Member).nickname?.match(/『(.*?)』/);
                        
                        await mess.edit({ content:"", embeds: [embed] });
                        
                        await doc.loadInfo();
                        const sheet = doc.sheetsByIndex[2];
                        await sheet.loadCells("A1:D"+(list.length+3));
                        sheet.getCell(index+1, 0).value = inte.user.username;
                        sheet.getCell(index+1, 1).value = role_rank[rank?.at(1) ?? "?"]
                        sheet.getCell(index+1, 2).value = 0
                        sheet.getCell(index+1, 3).value = inte.user.id;
                        await sheet.saveUpdatedCells();
                    }else {
                        const embed = new Discord.EmbedBuilder()
                        .setAuthor({ name: inte.user.username, iconURL: member.displayAvatarURL() as string })
                        .setTitle("포인트 확인")
                        .setDescription(`- <:point:1303014441851420752> : ${list[index-1].point}`);
                        
                        await mess.edit({ content:"", embeds: [embed] });
                    }
                }else {
                    await inte.reply({
                        content: "이 명령어는 "+Discord.channelMention(this.channel_id)+"에서만 사용할 수 있습니다",
                        ephemeral: true
                    });
                }
            }else if(inte.commandName == "포인트_추가") {
                result = true;
                const user = inte.options.getMember("유저") as Member;
                const point = inte.options.get("포인트")?.value as number;

                const mess = await inte.reply({ content:"<a:load:1303002986359951410>", ephemeral: true });

                get_doc.setOption({ sheetId: process.env.S_USER });
                const list = await get_doc.parse() as Sheet_User[];
                const index = list.findIndex((d) => d.user_id == user.id) + 1;
                await doc.loadInfo();
                const sheet = doc.sheetsByIndex[2];
                await sheet.loadCells("A1:D"+(list.length+3));
                if(index == 0) {
                    await mess.edit(user.user.username+"님의 포인트 +"+point+" 추가 완료");
                    sheet.getCell(list.length+1, 0).value = user.user.username;
                    sheet.getCell(list.length+1, 1).value = role_rank[user.nickname?.match(/『(.*?)』/)?.at(1) ?? "?"]
                    sheet.getCell(list.length+1, 2).value = point
                    sheet.getCell(list.length+1, 3).value = user.id;
                    await sheet.saveUpdatedCells();
                }else {
                    await mess.edit(user.user.username+"님의 포인트 +"+point+" 추가 완료");
                    sheet.getCell(index, 2).value = list[index-1].point + point;
                    await sheet.saveUpdatedCells();
                }
            }else if(inte.commandName == "포인트_차감") {
                result = true;
                const user = inte.options.getMember("유저") as Member;
                const point = inte.options.get("포인트")?.value as number;

                const mess = await inte.reply({ content:"<a:load:1303002986359951410>", ephemeral: true });

                get_doc.setOption({ sheetId: process.env.S_USER });
                const list = await get_doc.parse() as Sheet_User[];
                const index = list.findIndex((d) => d.user_id == user.id) + 1;
                await doc.loadInfo();
                const sheet = doc.sheetsByIndex[2];
                await sheet.loadCells("A1:D"+(list.length+3));
                if(index == 0 || list[index-1].point < point) {
                    await mess.edit(user.user.username+ "님은 포인트가 그것보다 부족합니다");
                }else {
                    await mess.edit(user.user.username+"님의 포인트 -"+point+" 차감 완료");
                    sheet.getCell(index, 2).value = list[index-1].point - point;
                    await sheet.saveUpdatedCells();
                }
            }
        }
        return result;
    }
}