import * as Discord from 'discord.js';
import { max_lenght } from '.';
import { Inte, mess_op } from '../../../type';
export const data_break:Map<string, mess_op> = new Map();
export const save_data:Map<string, mess_op> = new Map();
export const user_index:Map<string, number> = new Map();

export async function rank_button(inte:Inte, rank:{ id:string, level:number, xp:number }[]):Promise<boolean> {
    if(!inte.isButton()) return false;
    var result = false;

    if(inte.customId == "rank_perv") {
        result = true;
        const id = inte.user.id;
        const index = (user_index.get(id) as number)-1;
        const mess = (save_data.get(id) as mess_op)[index];
        user_index.set(id, index);
        await inte.update({
            embeds:mess?.embeds,
            components:mess?.components
        });
        (data_break.get(id) as mess_op)[index] = ({ embeds:mess?.embeds, components:mess?.components });
    }else if(inte.customId == "rank_next") {
        result = true;

        const embed = inte.message.embeds[0];
        const length = Number(embed.description?.replace("위", ""))+10;
        if(length <= max_lenght) {
            break_save(inte.user.id);

            const newEmbed = Discord.EmbedBuilder.from(embed)
            .setDescription(length+"위")
            .setFields([]);
            
            for(let i=length-10; i < length; i++) {
                newEmbed.addFields([{ name: (i+1)+"위", value: Discord.userMention(rank[i].id)+" : "+rank[i].level+" 레벨 / xp: "+rank[i].xp }]);
            }
            const row = row_button(length);
            
            inte.update({
                embeds:[newEmbed],
                components:[row]
            });
            
            const index = user_index.get(inte.user.id) as number;
            (data_break.get(inte.user.id) as mess_op)[index] = ({ embeds:[newEmbed], components:[row] });
        }
    }

    return result;
}

export function break_save(id:string) {
    const index = user_index.get(id) as number;
    user_index.set(id, index+1);
    const mess = (data_break.get(id) as mess_op)[index];
    (save_data.get(id) as mess_op)[index] = { embeds:mess?.embeds, components:mess?.components }
}

export function row_button(length:number):Discord.ActionRowBuilder<Discord.ButtonBuilder> {
    const row = new Discord.ActionRowBuilder<Discord.ButtonBuilder>();
    const btn_1 = new Discord.ButtonBuilder()
    .setLabel("이전")
    .setCustomId("rank_perv")
    .setEmoji("<a:prev:1290228050952458282>")
    .setStyle(Discord.ButtonStyle.Secondary);

    const btn_2 = new Discord.ButtonBuilder()
    .setLabel("다음")
    .setCustomId("rank_next")
    .setEmoji("<a:next:1290228110498729994>")
    .setStyle(Discord.ButtonStyle.Secondary);

    if(length <= 10) {
        btn_1.setDisabled(true);
    }else if(length >= max_lenght) {
        btn_2.setDisabled(true);
    }
    row.addComponents(btn_1, btn_2);

    return row;
}