import * as Discord from 'discord.js';
import { Command } from '../../../setting';
import { Inte } from '../../../type';

export default class Admin implements Command {
    command() {
        return [
            new Discord.SlashCommandBuilder().setName("메서지청소").setDescription("메시지를 청소합니다")
            .addIntegerOption(option =>
                option.setName("수량")
                .setDescription("청소할 메시지의 수량을 입력해주세요")
                .setRequired(true)
            ).setDefaultMemberPermissions(Discord.PermissionFlagsBits.Administrator)
        ]
    }

    async run(inte:Inte) {
        let result = false;
        if(inte.isCommand()) {
            if(inte.commandName == "메서지청소") {
                result = true;
                const amount = inte.options.get("수량")?.value as number;
                if(inte.channel?.type == Discord.ChannelType.GuildText) {
                    const messages = await inte.channel.messages.fetch({ limit: amount });
                    await inte.channel.bulkDelete(messages);
                    await inte.reply({ content: `메시지 ${amount}개를 삭제했습니다`, ephemeral: true });
                }
            }
        }
        return result;
    }
}