/*
 * Decompiled with CFR 0.152.
 */
package pokelucky;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;

public class EntityMoster
extends MobEntity
implements IMob,
IInventory {
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private static final DataParameter<Integer> ID_SIZE = EntityDataManager.func_187226_a(EntityMoster.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float targetSquish;
    public float squish;
    public float oSquish;
    private boolean wasOnGround;

    public EntityMoster(EntityType<? extends EntityMoster> p_i48552_1_, World p_i48552_2_) {
        super(p_i48552_1_, p_i48552_2_);
        this.field_70765_h = new MoveHelperController(this);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233821_d_, 1.0).func_233815_a_(Attributes.field_233823_f_, 0.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new FloatGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FaceRandomGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new HopGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, p_213811_1_ -> Math.abs(p_213811_1_.func_226278_cu_() - this.func_226278_cu_()) <= 4.0));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ID_SIZE, (Object)1);
    }

    protected void setSize(int p_70799_1_, boolean p_70799_2_) {
        this.field_70180_af.func_187227_b(ID_SIZE, (Object)p_70799_1_);
        this.func_226264_Z_();
        this.func_213323_x_();
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)(p_70799_1_ * p_70799_1_));
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)(0.2f + 0.1f * (float)p_70799_1_));
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a((double)p_70799_1_);
        if (p_70799_2_) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.field_70728_aV = p_70799_1_;
    }

    public int getSize() {
        return (Integer)this.field_70180_af.func_187225_a(ID_SIZE);
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("Size", this.getSize() - 1);
        p_213281_1_.func_74757_a("wasOnGround", this.wasOnGround);
        ItemStackHelper.func_191282_a((CompoundNBT)p_213281_1_, this.items);
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        int i = p_70037_1_.func_74762_e("Size");
        if (i < 0) {
            i = 0;
        }
        this.setSize(i + 1, false);
        super.func_70037_a(p_70037_1_);
        this.wasOnGround = p_70037_1_.func_74767_n("wasOnGround");
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)p_70037_1_, this.items);
    }

    public boolean isTiny() {
        return this.getSize() <= 1;
    }

    protected IParticleData getParticleType() {
        return ParticleTypes.field_239811_B_;
    }

    protected boolean func_225511_J_() {
        return this.getSize() > 0;
    }

    public void func_70071_h_() {
        this.squish += (this.targetSquish - this.squish) * 0.5f;
        this.oSquish = this.squish;
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            int i = this.getSize();
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                this.field_70170_p.func_195594_a(this.getParticleType(), this.func_226277_ct_() + (double)f2, this.func_226278_cu_(), this.func_226281_cx_() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.func_184185_a(this.getSquishSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.targetSquish = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.targetSquish = 1.0f;
        }
        this.wasOnGround = this.field_70122_E;
        this.decreaseSquish();
    }

    protected void decreaseSquish() {
        this.targetSquish *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    public void func_213323_x_() {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    public void func_184206_a(DataParameter<?> p_184206_1_) {
        if (ID_SIZE.equals(p_184206_1_)) {
            this.func_213323_x_();
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
            if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
                this.func_71061_d_();
            }
        }
        super.func_184206_a(p_184206_1_);
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
    }

    public void func_70108_f(Entity p_70108_1_) {
        super.func_70108_f(p_70108_1_);
        if (p_70108_1_ instanceof IronGolemEntity && this.isDealsDamage()) {
            this.dealDamage((LivingEntity)p_70108_1_);
        }
    }

    public void func_70100_b_(PlayerEntity p_70100_1_) {
        if (this.isDealsDamage()) {
            this.dealDamage((LivingEntity)p_70100_1_);
        }
    }

    protected void dealDamage(LivingEntity p_175451_1_) {
        if (this.func_70089_S()) {
            int i = this.getSize();
            if (this.func_70068_e((Entity)p_175451_1_) < 0.6 * (double)i * 0.6 * (double)i && this.func_70685_l((Entity)p_175451_1_) && p_175451_1_.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), this.getAttackDamage())) {
                this.func_184185_a(SoundEvents.field_187881_gQ, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_174815_a((LivingEntity)this, (Entity)p_175451_1_);
            }
        }
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 0.625f * p_213348_2_.field_220316_b;
    }

    protected boolean isDealsDamage() {
        return !this.isTiny() && this.func_70613_aW();
    }

    protected float getAttackDamage() {
        return (float)this.func_233637_b_(Attributes.field_233823_f_);
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.isTiny() ? SoundEvents.field_187603_D : SoundEvents.field_187603_D;
    }

    protected SoundEvent func_184615_bR() {
        return this.isTiny() ? SoundEvents.field_187692_g : SoundEvents.field_187692_g;
    }

    protected SoundEvent getSquishSound() {
        return this.isTiny() ? SoundEvents.field_187881_gQ : SoundEvents.field_187881_gQ;
    }

    protected ResourceLocation func_184647_J() {
        return this.getSize() == 1 ? this.func_200600_R().func_220348_g() : LootTables.field_186419_a;
    }

    public static boolean checkSlimeSpawnRules(EntityType<EntityMoster> p_223366_0_, IWorld p_223366_1_, SpawnReason p_223366_2_, BlockPos p_223366_3_, Random p_223366_4_) {
        if (p_223366_1_.func_175659_aa() != Difficulty.PEACEFUL) {
            boolean flag;
            if (Objects.equals(p_223366_1_.func_242406_i(p_223366_3_), Optional.of(Biomes.field_76780_h)) && p_223366_3_.func_177956_o() > 50 && p_223366_3_.func_177956_o() < 70 && p_223366_4_.nextFloat() < 0.5f && p_223366_4_.nextFloat() < p_223366_1_.func_242413_ae() && p_223366_1_.func_201696_r(p_223366_3_) <= p_223366_4_.nextInt(8)) {
                return EntityMoster.func_223315_a(p_223366_0_, (IWorld)p_223366_1_, (SpawnReason)p_223366_2_, (BlockPos)p_223366_3_, (Random)p_223366_4_);
            }
            if (!(p_223366_1_ instanceof ISeedReader)) {
                return false;
            }
            ChunkPos chunkpos = new ChunkPos(p_223366_3_);
            boolean bl = flag = SharedSeedRandom.func_205190_a((int)chunkpos.field_77276_a, (int)chunkpos.field_77275_b, (long)((ISeedReader)p_223366_1_).func_72905_C(), (long)987234911L).nextInt(10) == 0;
            if (p_223366_4_.nextInt(10) == 0 && flag && p_223366_3_.func_177956_o() < 40) {
                return EntityMoster.func_223315_a(p_223366_0_, (IWorld)p_223366_1_, (SpawnReason)p_223366_2_, (BlockPos)p_223366_3_, (Random)p_223366_4_);
            }
        }
        return false;
    }

    protected float func_70599_aP() {
        return 0.4f * (float)this.getSize();
    }

    public int func_70646_bf() {
        return 0;
    }

    protected boolean doPlayJumpSound() {
        return this.getSize() > 0;
    }

    protected void func_70664_aZ() {
        Vector3d vector3d = this.func_213322_ci();
        this.func_213293_j(vector3d.field_72450_a, this.func_175134_bD(), vector3d.field_72449_c);
        this.field_70160_al = true;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        int i = this.field_70146_Z.nextInt(3);
        if (i < 2 && this.field_70146_Z.nextFloat() < 0.5f * p_213386_2_.func_180170_c()) {
            ++i;
        }
        int j = 1 << i;
        this.setSize(j, true);
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    private float getSoundPitch() {
        float f = this.isTiny() ? 1.4f : 0.8f;
        return ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * f;
    }

    protected SoundEvent getJumpSound() {
        return this.isTiny() ? SoundEvents.field_187881_gQ : SoundEvents.field_187881_gQ;
    }

    public EntitySize func_213305_a(Pose p_213305_1_) {
        return super.func_213305_a(p_213305_1_).func_220313_a(0.255f * (float)this.getSize());
    }

    protected boolean spawnCustomParticles() {
        return false;
    }

    protected void setItems(NonNullList<ItemStack> p_199721_1_) {
        this.items = p_199721_1_;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        return this.items.stream().allMatch(ItemStack::func_190926_b);
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return (ItemStack)this.items.get(p_70301_1_);
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.items, (int)p_70298_1_, (int)p_70298_2_);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return ItemStackHelper.func_188383_a(this.items, (int)p_70304_1_);
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.items.set(p_70299_1_, (Object)p_70299_2_);
        if (p_70299_2_.func_190916_E() > this.func_70297_j_()) {
            p_70299_2_.func_190920_e(this.func_70297_j_());
        }
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(PlayerEntity p_70300_1_) {
        return false;
    }

    static class MoveHelperController
    extends MovementController {
        private float yRot;
        private int jumpDelay;
        private final EntityMoster slime;
        private boolean isAggressive;

        public MoveHelperController(EntityMoster p_i45821_1_) {
            super((MobEntity)p_i45821_1_);
            this.slime = p_i45821_1_;
            this.yRot = 180.0f * p_i45821_1_.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float p_179920_1_, boolean p_179920_2_) {
            this.yRot = p_179920_1_;
            this.isAggressive = p_179920_2_;
        }

        public void setWantedMovement(double p_179921_1_) {
            this.field_75645_e = p_179921_1_;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = MovementController.Action.WAIT;
                if (this.field_75648_a.func_233570_aj_()) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.func_70683_ar().func_75660_a();
                        if (this.slime.doPlayJumpSound()) {
                            this.slime.func_184185_a(this.slime.getJumpSound(), this.slime.func_70599_aP(), this.slime.getSoundPitch());
                        }
                    } else {
                        this.slime.field_70702_br = 0.0f;
                        this.slime.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                }
            }
        }
    }

    static class HopGoal
    extends Goal {
        private final EntityMoster slime;

        public HopGoal(EntityMoster p_i45822_1_) {
            this.slime = p_i45822_1_;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.slime.func_184218_aH();
        }

        public void func_75246_d() {
            ((MoveHelperController)this.slime.func_70605_aq()).setWantedMovement(1.0);
        }
    }

    static class FloatGoal
    extends Goal {
        private final EntityMoster slime;

        public FloatGoal(EntityMoster p_i45823_1_) {
            this.slime = p_i45823_1_;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            p_i45823_1_.func_70661_as().func_212239_d(true);
        }

        public boolean func_75250_a() {
            return (this.slime.func_70090_H() || this.slime.func_180799_ab()) && this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            ((MoveHelperController)this.slime.func_70605_aq()).setWantedMovement(1.2);
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final EntityMoster slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(EntityMoster p_i45820_1_) {
            this.slime = p_i45820_1_;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab() || this.slime.func_70644_a(Effects.field_188424_y)) && this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.func_70681_au().nextInt(60);
                this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
            }
            ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AttackGoal
    extends Goal {
        private final EntityMoster slime;
        private int growTiredTimer;

        public AttackGoal(EntityMoster p_i45824_1_) {
            this.slime = p_i45824_1_;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.slime.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            return livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a ? false : this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75249_e() {
            this.growTiredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = this.slime.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTiredTimer > 0;
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, this.slime.isDealsDamage());
        }
    }
}

