import * as Discord from 'discord.js';
import { Inte } from './type';

export interface Command {
    command(): Discord.SlashCommandOptionsOnlyBuilder[];
    run(inte:Inte): Promise<boolean>
}

export class DiscordBot {
    private commandClass:Command[] = [];
    private command:Discord.SlashCommandOptionsOnlyBuilder[] = [];

    init(commandClass:Command) {
        this.commandClass.push(commandClass);
        commandClass.command().forEach(command => this.command.push(command));
    }

    setting(guild_id:string) {
        const rest = new Discord.REST().setToken(process.env.TOKEN as string);
        const body = exception(this.command, guild_id);

        rest.put(Discord.Routes.applicationGuildCommands(process.env.CLIENT_ID as string, guild_id), {body: body})
        .then(() => console.log('슬래시 명령어 등록 완료'))
        .catch(console.error);
    }

    async run(inte:Inte) {
        for(const commandClass of this.commandClass) {
            if(await commandClass.run(inte)) {
                break;
            }
        }
    }
}

function exception(command: Discord.SlashCommandOptionsOnlyBuilder[], guild_id: string) {
    let json = command.map(command => command.toJSON());
    if(guild_id != "1154317092259115118" && guild_id != "1162281811624341524") {
        const mine = command.findIndex(command => command.name === '마크');
        json.splice(mine, 1);
    }
    return json;
}