import * as Discord from 'discord.js';
import { game_board, gameLoop, game_over, newPiece, score, tetris_move, canMove } from './tetris';
import { Command } from '../../setting';
import { Inte } from '../../type';
export const block:string[] = [];
export const maxX = 10;
export const maxY = 13;
export const game_loop = new Map<string,NodeJS.Timeout>();

export default class Tetris implements Command {
    
    command() {
        block.push("<:d_:1256436152047501494>");
        block.push("<:1_:1256398366028599408>");
        block.push("<:2_:1256397986653536310>");
        block.push("<:3_:1256846336591134770>");
        block.push("<:4_:1256846730524098561>");
        block.push("<:5_:1256846909633593375>");
        block.push("<:6_:1256847070258659398>");
        return [
            new Discord.SlashCommandBuilder().setName("테트리스").setDescription("테트리스 게임을 시작합니다")
            .addStringOption(option =>
                option.setName("difficulty")
                .setDescription("난이도를 선택해주세요")
                .setChoices([
                    { name:"쉬움", value:"2500"},
                    { name:"보통", value:"2000"},
                    { name:"어려움", value:"1500"}
                ]).setRequired(true)
            )
        ];
    }

    async run(inte: Inte) {
        var result = false;
        if (inte.isCommand()) {
            if (inte.commandName == "테트리스") {
                result = true;
                const difficulty = inte.options.get("difficulty")!.value as string;

                var board:number[][] = [];
                for(let i=0; i < maxY; i++) {
                    board[i] = [];
                    for(let j=0; j < maxX; j++) {
                        board[i][j] = 0;
                    }
                }
                game_board.set(inte.user.id, board);
                score.set(inte.user.id, 0);

                newPiece(inte.user.id);
                const message = this.message(gameLoop(inte.user.id), inte.user);
                const start = await inte.reply(message);

                var mess = await start.edit(message);
                const loop = setInterval(async () => {
                    var message = this.message(gameLoop(inte.user.id), inte.user);
                    mess = await mess.edit(message);
                },Number(difficulty));

                game_loop.set(inte.user.id, loop);
            }
        }else if(inte.isButton()) {
            if(inte.customId == "tetris_left") {
                result = true;
                var message = this.message(tetris_move("left", inte.user.id), inte.user);
                await inte.update(message);
            }else if(inte.customId == "tetris_right") {
                result = true;
                var message = this.message(tetris_move("right", inte.user.id), inte.user);
                await inte.update(message);
            }else if(inte.customId == "tetris_down") {
                result = true;
                var message = this.message(tetris_move("down", inte.user.id), inte.user);
                await inte.update(message);
            }else if(inte.customId == "tetris_rotate") {
                result = true;
                var message = this.message(tetris_move("rotate", inte.user.id), inte.user);
                await inte.update(message);
            }else if(inte.customId == "tetris_exit") {
                result = true;
                game_over(inte.user.id);
                const embed = inte.message.embeds[0];
                const edit_embed = Discord.EmbedBuilder.from(embed).setFields(
                    { name:"테트리스 결과", value:"점수: "+score.get(inte.user.id) }
                ).setTitle("종료");
                inte.update({embeds:[edit_embed]});
            }
        }
        return result;
    }

    message(game:string, user:Discord.User) {
        return {
            embeds:[new Discord.EmbedBuilder()
            .setTitle("테트리스")
            .setAuthor({name:"플레이어: "+user.username, iconURL:user.displayAvatarURL()})
            .setFields([
                { name:"점수", value:score.get(user.id)+"점", inline:true}
            ])
            .setDescription(game)],

            components:[
                new Discord.ActionRowBuilder<Discord.ButtonBuilder>()
                .setComponents([
                    new Discord.ButtonBuilder()
                   .setCustomId("tetris_left")
                   .setStyle(Discord.ButtonStyle.Primary)
                   .setEmoji("<:p_direct_left:1121239127430545540>")
                   .setLabel("왼쪽"),

                   new Discord.ButtonBuilder()
                   .setCustomId("tetris_right")
                   .setEmoji("<:p_direct_right:1121239135596838934>")
                   .setStyle(Discord.ButtonStyle.Primary)
                   .setLabel("오른쪽"),

                   new Discord.ButtonBuilder()
                   .setCustomId("tetris_down")
                   .setLabel("아래")
                   .setEmoji("<:p_direct_down:1121239119864021042>")
                   .setStyle(Discord.ButtonStyle.Primary),

                   new Discord.ButtonBuilder()
                   .setCustomId("tetris_rotate")
                   .setStyle(Discord.ButtonStyle.Primary)
                   .setEmoji("🔄")
                   .setLabel("회전"),

                   new Discord.ButtonBuilder()
                   .setCustomId("tetris_exit")
                   .setLabel("종료")
                   .setStyle(Discord.ButtonStyle.Danger)
                   .setEmoji("<:no:1254760072761049199>")
                ])
            ]
        }
    }
}