import * as Discord from 'discord.js';
import { execSync } from "child_process";
import { Command } from '../setting';
import { Inte } from '../type';

export default class Mine implements Command {
    private message_bot:{
        mess:Discord.InteractionResponse<boolean>,
        user:string,
        on:boolean
    }[] = [];

    command() {
        return [
            new Discord.SlashCommandBuilder().setName("마크").setDescription("마인크래프트 서버 정보를 확인합니다")
            .addStringOption(option =>
                option.setName("옵션")
                .setDescription("옵션을 선택해주세요")
                .addChoices([
                    { name:"서버 목록", value:"1"},
                    { name:"서버 명령", value:"2"}
                ]).setRequired(true)
            )
        ]
    }

    async run(inte:Inte) {
        let result = false;
        if(inte.isCommand()) {
            if(inte.commandName == "마크") {
                result = true;
                const option = inte.options.get("옵션")?.value as number;
                if(option == 1) {
                    const mess = await inte.reply("<a:load:1294327720028672052>");
                    const curl = execSync('curl -X GET -k -H "Authorization: Bearer "'+process.env.CRAFTY+'"" https://home.ourgram.co.kr:8443/api/v2/servers/status').toString();
                    const json = JSON.parse(curl) as { status:string, data: { world_name:string, running:boolean, online:number, id:string }[] };
                    const embed = new Discord.EmbedBuilder()
                    .setTitle("서버 목록")
                    .setColor("#ffffff");
                    
                    var embed_field = [] as { name:string, value:string }[];
                    json.data.forEach((data) => {
                        var run:string;
                        if(data.running) {
                            run = "⭕ : 실행중";
                        }else {
                            run = "❌ : 종료됨";
                        }
                        embed_field.push({ name:data.world_name, value:"🆔 : "+data.id+" \n "+run+"\n 👤 접속중:"+data.online+"명"});
                    });
                    
                    embed.setFields(embed_field);
                    await mess.edit({ content:"", embeds:[embed] });
                }else if(option == 2) {
                    const embed = new Discord.EmbedBuilder()
                    .setTitle("서버 명령")
                    .setColor("#ffffff");
                    
                    const menu = new Discord.StringSelectMenuBuilder()
                    .setCustomId("서버_명령")
                    .setPlaceholder("서버 명령 선택")
                    .setOptions(
                        new Discord.StringSelectMenuOptionBuilder()
                        .setValue("1")
                        .setLabel("실행")
                        .setDescription("서버를 실행합니다")
                        .setEmoji("<a:discordon:1187624289399218256>"),
                        
                        new Discord.StringSelectMenuOptionBuilder()
                        .setValue("2")
                        .setLabel("종료")
                        .setDescription("마크 서버를 종료 시킵니다")
                        .setEmoji("<:q_off:1199355896342511738>")
                    );
                    
                    const row = new Discord.ActionRowBuilder<Discord.StringSelectMenuBuilder>()
                    .setComponents(menu);
                    
                    await inte.reply({
                        embeds:[embed],
                        components:[row]
                    });
                }
            }
        }else if(inte.isStringSelectMenu()) {
            if(inte.customId == "서버_명령") {
                result = true;
                const option = inte.values[0] as unknown as number;
                const curl = execSync('curl -X GET -k -H "Authorization: Bearer "'+process.env.CRAFTY+'"" https://home.ourgram.co.kr:8443/api/v2/servers/status').toString();
                const json = JSON.parse(curl) as { status:string, data: { world_name:string, running:boolean, online:number, id:string }[] };
                if(option == 1) {
                    var is = 0;
                    json.data.forEach((data) => {
                        if(data.running) {
                            is = 1;
                        }
                    });
                    if(is) {
                        await inte.update({content:"실행 중인 서버가 있습니다 먼저 종료하고 해주세요", embeds:[], components:[]});
                        return result;
                    }
                    const embed = new Discord.EmbedBuilder()
                    .setTitle("실행할 서버 선택")
                    .setColor("#ffffff");
                    
                    const row = new Discord.ActionRowBuilder<Discord.StringSelectMenuBuilder>();
                    const select = new Discord.StringSelectMenuBuilder()
                    .setCustomId("서버_선택")
                    .setPlaceholder("서버 선택");

                    for(const server of json.data) {
                        select.addOptions(
                            new Discord.StringSelectMenuOptionBuilder()
                            .setValue(server.id)
                            .setLabel(server.world_name)
                            .setDescription("🆔 : "+server.id)
                        );
                    }
                    row.addComponents(select);
                    
                    const mess = await inte.update({
                        embeds:[embed],
                        components:[row]
                    });
                    
                    this.message_bot.push({mess:mess, user:inte.user.id, on:true});
                }else if(option == 2) {
                    const embed = new Discord.EmbedBuilder()
                    .setTitle("종료할 서버 선택")
                    .setColor("#ff0000");
                    
                    const row = new Discord.ActionRowBuilder<Discord.StringSelectMenuBuilder>();
                    const select = new Discord.StringSelectMenuBuilder()
                    .setCustomId("서버_선택")
                    .setPlaceholder("서버 선택");

                    for(const server of json.data) {
                        select.addOptions(
                            new Discord.StringSelectMenuOptionBuilder()
                            .setValue(server.id)
                            .setLabel(server.world_name)
                            .setDescription("🆔 : "+server.id)
                        );
                    }
                    row.addComponents(select);
                    
                    const mess = await inte.update({
                        embeds:[embed],
                        components:[row]
                    });
                    
                    this.message_bot.push({mess:mess, user:inte.user.id, on:false});
                }
            }else if(inte.customId == "서버_선택") {
                result = true;
                const id = inte.values[0] as string;
                var on:string;
            
                this.message_bot.forEach((bot) => {
                    if(bot.user == inte.user.id) {
                        if(bot.on) {
                            on = "start_server";
                            console.log(inte.user.username+"님이 서버를 시작했습니다");
                        }else {
                            on = "stop_server";
                            console.log(inte.user.username+"님이 서버를 종료했습니다");
                        }
                        const curl = execSync('curl -X POST -k -H "Authorization: Bearer '+process.env.CRAFTY+'" https://home.ourgram.co.kr:8443/api/v2/servers/'+id+'/action/'+on);
                        const json = JSON.parse(curl.toString()) as { status:string };
                        if(json.status == "ok") {
                            bot.mess.edit({
                                content:on+"성공",
                                embeds:[],
                                components:[]
                            });
                        }else if(json.status == "error") {
                            bot.mess.edit({
                                content:"실패: 서버 혹은 id 가 잘못되었습니다",
                                embeds:[],
                                components:[]
                            });
                        }
                        inte.deferUpdate();
                    }
                });
            }
        }
        return result;
    }
}