import * as Discord from 'discord.js';
import { execSync } from "child_process";
import { Command } from '../setting';
import { Inte } from '../type';

export default class Gpt implements Command {
    command() {
        return [
            new Discord.SlashCommandBuilder().setName("ai").setDescription("gpt에게 질문 할수 있습니다")
            .addStringOption(option =>
                option.setName("query")
                .setDescription("질문을 적으세요")
                .setRequired(true)
            )
        ];
    }

    async run(inte: Inte) {
        var result = false;
        if(inte.isCommand()) {
            if(inte.commandName == "ai") {
                result = true;
                const mess = await inte.reply("<a:sans_load:1244596991338745866>");
                var query = inte.options.get("query")!.value as string;
                const answer = execSync("tgpt -q '"+query+"'").toString();
                mess.edit(answer);
            }
        }
        return result;
    }
}