import { get_doc } from "../../../init";
import { Sheet_fishing } from "../../../type";

export async function getData(id:string) {
    get_doc.setOption({ sheetId: process.env.S_FISHING });
    const list = await get_doc.parse() as Sheet_fishing[];
    const index = list.findIndex((d) => d.user_id == id);
    return {
        d: list[index],
        row:index+1,
        length: list.length+2
    };
}

export const position: { [key in string]: {url:string, time:number, price:number, fish:string[]} } = {
    "강" : {
        url:"https://res.ourgram.co.kr/discord/fishing/river.gif",
        time:60000,
        price:10000,
        fish: ["마리모", "고등어", "갈치", "연어", "알래스카 킹크랩"]
    },
    // "연못" : {
    //     url:"https://res.ourgram.co.kr/discord/fishing/pond.gif",
    //     time:50000,
    //     price:2500
    // },
    "바다": {
        url: "https://res.ourgram.co.kr/discord/fishing/sea.gif",
        time:60000,
        price:10000,
        fish: ["산호초", "참돔", "조개", "불가사리", "오징어", "문어", "쭈꾸미", "킹블랙 타이거 새우"]
    },
    // "저수지": {
    //     url: "https://res.ourgram.co.kr/discord/fishing/reservoir.gif",
    //     time:200000,
    //     price:20000
    // },
    "심해": {
        url: "https://res.ourgram.co.kr/discord/fishing/deep.gif",
        time:60000,
        price:10000,
        fish: ["꽁치", "금붕어", "피라미", "해파리", "그린란드 상어", "핑크 돌고래", "레드 킹크랩"]
    },
    // "빙하": {
    //     url: "https://res.ourgram.co.kr/discord/fishing/glacial.gif",
    //     time:300000,
    //     price:30000
    // }
};

export type fish_rank = "흔함" | "희귀" | "귀함" | "전설" | "신화"
export const fish_price: { [key in fish_rank]:{ point:number, price:number } } = {
    "흔함": {
        point:3,
        price:1000
    },
    "희귀": {
        point: 5,
        price:1800
    },
    "귀함": {
        point: 30,
        price:9000
    },
    "전설": {
        point: 130,
        price:14000
    },
    "신화": {
        point:200,
        price:23000
    }
}
export const fish: { [key in string]: {emoji:string, rank:fish_rank} } = {
    "갈치": {
        emoji: "<:cutlassfish:1303521596878753893>",
        rank: "흔함"
    },
    "꽁치": {
        emoji: "<:saury:1303522308337569802>",
        rank: "흔함"
    },
    "금붕어": {
        emoji: "<:goldfish:1303523050192507010>",
        rank: "흔함"
    },
    "피라미": {
        emoji: "<:minnow:1303523611117879297>",
        rank: "흔함"
    },
    "마리모": {
        emoji: "<:marimo:1303525427406704690>",
        rank: "흔함"
    },
    "산호초": {
        emoji: "<:coral_reef:1303526521188646933>",
        rank: "흔함"
    },

    "연어": {
        emoji: "<:salmon:1303527048278704148>",
        rank: "희귀"
    },
    "참돔": {
        emoji: "<:bream:1303527671040442388>",
        rank: "희귀"
    },
    "참치": {
        emoji: "<:tuna:1303520093065707564>",
        rank: "희귀"
    },
    "새우": {
        emoji: "<:shrimp:1303529073884139520>",
        rank: "희귀"
    },
    "해파리": {
        emoji: "<:jellyfish:1303529256449736795>",
        rank: "희귀"
    },
    "조개": {
        emoji: "<:shellfish:1304741701356752896>",
        rank: "귀함"
    },
    "불가사리": {
        emoji: "<:starfish:1304741991971688489>",
        rank: "귀함"
    },
    "오징어": {
        emoji: "<:squid:1304742832229060618>",
        rank: "귀함"
    },
    "문어": {
        emoji: "<:octopus:1304743424154538057>",
        rank: "귀함"
    },
    "그린란드 상어": {
        emoji: "<:greenland_shark:1304744204211322951>",
        rank: "전설"
    },
    "핑크 돌고래": {
        emoji: "<:pink_dolphin:1304746281821933609>",
        rank: "전설"
    },
    "레드 킹크랩": {
        emoji: "<:red_king_crab:1304747074469761085>",
        rank: "전설"
    },
    "킹블랙 타이거 새우": {
        emoji: "<:king_black_tiger_shrimp:1304747827641192498>",
        rank: "신화"
    },
    "알래스카 킹크랩": {
        emoji: "<:alaska_king_crab:1304749273287495680>",
        rank: "신화"
    }
};

export const fishing_rod: { id:number, name: string, time:number, price: number, weights:number }[] = [
    {
        id: 1,
        name: "낡은 낚싯대",
        time: 0,
        price: 100,
        weights:1
    },
    {
        id: 2,
        name: "일반 낚싯대",
        time: 10000,
        price: 30000,
        weights:1
    },
    {
        id: 7,
        name: "레어 낚싯대",
        time: 30000,
        price: 150000,
        weights:1
    },
    {
        id: 3,
        name: "희귀 낚싯대",
        time: 50000,
        price: 300000,
        weights:1.2
    },
]