import * as Discord from 'discord.js';
import { doc, get_doc } from '../../../init';
import { Sheet_level } from '../../../type';
export const mess_LEVEL_UP_BASE = 380;
const XP_PER_MINUTE = 35;
const exception_mess = [
    "http", "@", "#"
];
const exception_channel = [
    "로그", "공지", "안내", "규칙"
];
const exception_id = [
    ""
];

export async function level_mess(message:Discord.Message) {
    if(message.author.bot) return;
    if(!message.content) return;
    if(exception_mess.some((d) => message.content.includes(d))) return;

    const channel = message.channel as Discord.TextChannel;
    if(exception_channel.includes(channel.id)) return;
    if(exception_id.includes(channel.parentId as string)) return;
    if(exception_id.includes(channel.id)) return;
    if(exception_channel.includes(channel.name)) return;
    if(message.content.length <= 8) return;

    get_doc.setOption({ sheetId: process.env.S_LEVEL_MESS });
    const data = await get_doc.parse() as Sheet_level[];
    const row = data.findIndex((d) => d.user_id == message.author.id) + 1;
    await doc.loadInfo();
    const sheet = doc.sheetsByIndex[3];
    await sheet.loadCells("A1:D"+data.length+3);
    if(row != 0) {
        const xp = data[row-1].xp.split("/");
        let LEVEL_UP_BASE = Number(xp[0]);
        let newXP = Number(xp[1]) + XP_PER_MINUTE;
        let level = data[row-1].level;
        let user_xp = data[row-1].xp;
        if(newXP >= LEVEL_UP_BASE) {
            while(newXP >= LEVEL_UP_BASE) {
                newXP -= LEVEL_UP_BASE;
                LEVEL_UP_BASE *= 2;
                level++;
            }
            if(newXP < 0) {
                newXP = 0;
            }
            user_xp = LEVEL_UP_BASE+" / "+newXP;
        }else {
            user_xp = LEVEL_UP_BASE+" / "+newXP;
        }
        sheet.getCell(row, 1).value = level;
        sheet.getCell(row, 2).value = user_xp;
    }else {
        sheet.getCell(data.length+1, 0).value = message.author.username;
        sheet.getCell(data.length+1, 1).value = 1;
        sheet.getCell(data.length+1, 2).value = mess_LEVEL_UP_BASE+" / "+XP_PER_MINUTE;
        sheet.getCell(data.length+1, 3).value = message.author.id;
    }
    await sheet.saveUpdatedCells();
}