import * as Discord from 'discord.js';
import { Command } from '../../setting';
import { Inte } from '../../type';

export default class Meeting implements Command {
    command() {
        return [
        ]
    }

    async run(inte:Inte) {
        let result = false;
        if(inte.isButton()) {
            if(inte.customId == "meeting_reason") {
                result = true;
                const modal = new Discord.ModalBuilder()
                .setTitle("회의 불참사유")
                .setCustomId("meeting_reason");

                const row = new Discord.ActionRowBuilder<Discord.TextInputBuilder>();
                row.addComponents(
                    new Discord.TextInputBuilder()
                    .setCustomId("meeting_reason")
                    .setPlaceholder("회의 불참사유를 작성해주세요")
                    .setRequired(true)
                    .setStyle(Discord.TextInputStyle.Paragraph)
                );

                modal.addComponents(row);

                await inte.showModal(modal);
            }
        }else if(inte.isModalSubmit()) {
            if(inte.customId == "meeting_reason") {
                result = true;
            }
        }
        return result;
    }
}