import * as Discord from 'discord.js';
import * as canvas from 'canvas';
import { Command } from '../../../setting';
import { get_doc } from '../../../init';
import { Inte, Member, mess_op, Sheet_level } from '../../../type';
import { mess_LEVEL_UP_BASE } from '../../dynamic/message/level_mess';
import { voice_LEVEL_UP_BASE } from '../../dynamic/voice/level_voice';
import { data_break, save_data, user_index, rank_button, row_button } from './button';
export const max_lenght = 50;

export default class Level implements Command {
    private rank:{ id:string, level:number, xp:number }[] = [];

    command() {
        return [
            new Discord.SlashCommandBuilder().setName("레벨확인").setDescription("유저의 레벨을 확인합니다."),
            new Discord.SlashCommandBuilder().setName("전체랭킹").setDescription("참새서버에 전체 랭킹을 확인합니다")
            .addStringOption(option =>
                option.setName("type")
                .setDescription("랭킹 종류를 선택하세요")
                .addChoices([
                    { name: "채팅 랭킹", value: "채팅" },
                    { name: "음성 랭킹", value: "음성" }
                ])
                .setRequired(true)
            )
        ]
    }

    async run(inte:Inte) {
        let result = false;
        if(inte.isCommand()) {
            if(inte.commandName === "레벨확인") {
                result = true;
                const mess = await inte.reply("<a:load:1303002986359951410>");
                const member = inte.member as Member;
                const img = new Discord.AttachmentBuilder(await this.level_profile(member), { name: "level.png" });
                await mess.edit({
                    content: "",
                    files: [img],
                });
            }else if(inte.commandName == "전체랭킹") {
                result = true;
                const mess = await inte.reply("<a:load:1303002986359951410>");
                const option = inte.options.get("type")?.value as string;
                
                if(option == "채팅") {
                    get_doc.setOption({ sheetId: process.env.S_LEVEL_MESS });
                }else if(option == "음성") {
                    get_doc.setOption({ sheetId: process.env.S_LEVEL_VOICDE });
                }
                const value = await get_doc.parse() as Sheet_level[];
                
                this.rank = [];
                let exception:string[] = [];
                for(let i=0; i < max_lenght; i++) {
                    let max_user = { id:"0", level:0, xp:0 };
                    value.forEach(user => {
                        if(exception.includes(user.user_id)) return;
                        
                        if(max_user.level <= user.level) {
                            const xp = user.xp.split("/");
                            const xp_number = Number(xp[1]);
                            
                            if(max_user.level == user.level) {
                                if(xp_number <= max_user.xp) return;
                            }
                            
                            max_user = {
                                id: user.user_id,
                                level: user.level,
                                xp: xp_number
                            };
                        }
                    });
                    this.rank.push(max_user);
                    exception.push(max_user.id);
                }
                
                const embed = new Discord.EmbedBuilder()
                .setTitle("참새패밀리 "+option+"레벨 랭킹")
                .setDescription("10위")
                .setThumbnail(inte.guild?.iconURL() as string)
                .setTimestamp();
                for(let i=0; i < 10; i++) {
                    embed.addFields([{ name: (i+1)+"위", value: Discord.userMention(this.rank[i].id)+" : "+this.rank[i].level+" 레벨 / xp: "+this.rank[i].xp }]);
                }
                
                const row = row_button(10);
                
                data_break.set(inte.user.id, []);
                save_data.set(inte.user.id, []);
                user_index.set(inte.user.id, 0);
                
                (data_break.get(inte.user.id) as mess_op)[0] = ({ embeds:[embed], components:[row] });
                
                await mess.edit({ embeds:[embed], components:[row], content:"" });
            }
        }else if(inte.isButton()) {
            result = await rank_button(inte, this.rank);
        }
        return result;
    }

    async level_profile(member:Discord.GuildMember) {
        const can = canvas.createCanvas(700, 350);
        const ctx = can.getContext('2d');
        ctx.fillStyle = "#000";
        ctx.fillRect(0, 0, 700, 350);

        let avatar;
        try {
            avatar = await canvas.loadImage(member.displayAvatarURL().replace(/.webp/g, ".png"));
        }catch(e) {
            avatar = await canvas.loadImage("https://res.ourgram.co.kr/discord/profile.png");
        }
        ctx.drawImage(avatar, 25, 70, 200, 200);
        
        let fontSize = 28;
        const maxUsernameWidth = 38; 
        let is = false;
        let add = 0;
        while(ctx.measureText(member.user.username).width > maxUsernameWidth && fontSize > 10) {
            fontSize--;
            is = true;
        }
        if(is) add+=5;
        ctx.font = `bold ${fontSize+add}px sans-serif`;
        ctx.fillStyle = '#ffffff';
        ctx.fillText(member.user.username, 70+add, 310);

        get_doc.setOption({ sheetId: process.env.S_LEVEL_MESS });
        const value_mess = await get_doc.parse() as Sheet_level[];
        const userLevel_mess = value_mess.find((d) => d.user_id == member.id);
        
        let level_mess = 1;
        let xp_mess = mess_LEVEL_UP_BASE+" / 0";
        if(userLevel_mess) {
            level_mess = userLevel_mess.level;
            xp_mess = userLevel_mess.xp;
        }
        const xpArr_mess = xp_mess.split("/");
        ctx.font = 'bold 36px sans-serif';
        ctx.fillText('채팅 레벨: '+level_mess, 250, 80);
        this.drawXPBar(ctx, xpArr_mess, 250, 120);
        
        get_doc.setOption({ sheetId: process.env.S_LEVEL_VOICDE });
        const value_voice = await get_doc.parse() as Sheet_level[];
        const userLevel_voice = value_voice.find((d) => d.user_id == member.id);
        let level_voice = 1;
        let xp_voice = voice_LEVEL_UP_BASE+" / 0";
        if(userLevel_voice) {
            level_voice = userLevel_voice.level;
            xp_voice = userLevel_voice.xp;
        }
        const xpArr_voice = xp_voice.split("/");
        ctx.font = 'bold 36px sans-serif';
        ctx.fillText('음성 레벨: '+level_voice, 250, 230);
        this.drawXPBar(ctx, xpArr_voice, 250, 270);
        
        return can.toBuffer();
    }

    drawXPBar(ctx:canvas.CanvasRenderingContext2D, xp:string[], x:number, y:number) {
        const xpBarWidth = 400;
        const xpBarHeight = 20;
        
        ctx.fillStyle = '#484b51';
        ctx.fillRect(x, y, xpBarWidth, xpBarHeight);
        
        ctx.fillStyle = '#57f287';
        const xpProgress = Number(xp[1]) / Number(xp[0]);
        ctx.fillRect(x, y, xpBarWidth * xpProgress, xpBarHeight);
        
        ctx.fillStyle = '#ffffff';
        ctx.font = '16px sans-serif';
        ctx.fillText(`${xp[0]} / ${xp[1]} XP`, x, y + xpBarHeight + 15);
    }
}