import * as Discord from 'discord.js';
import { execSync } from 'child_process';
import { Command } from "../../setting";
import { Inte } from '../../type';

export default class Gpt implements Command {
    command() {
        return [
            new Discord.SlashCommandBuilder().setName("gpt").setDescription("GPT를 사용하여 질문의 답변을 제공합니다")
            .addStringOption(option =>
                option.setName("질문")
                .setDescription("GPT한테 물어볼 질문을 적어주세요")
                .setRequired(true)
            )
        ]
    }

    async run(inte:Inte) {
        let result = false;
        if(inte.isCommand()) {
            if(inte.commandName == "gpt") {
                result = true;
                const mess = await inte.reply("<a:load:1303002986359951410>");
                const query = inte.options.get("질문")?.value as string;
                const answer = execSync("gemini-cli prompt '"+query+"'").toString();
                const embed = new Discord.EmbedBuilder()
                .setAuthor({ name:inte.client.user.username, iconURL: inte.client.user.avatarURL() as string })
                .setColor("#FFFF00")
                .setDescription(answer);

                await mess.edit({ embeds:[embed], content:"" });
            }
        }
        return result;
    }
}