import * as Discord from 'discord.js';
import { Inte } from './main';

export interface Command {
    run(inte: Inte): Promise<boolean>;
    command(): Discord.SlashCommandOptionsOnlyBuilder[];
}

export class DiscordBot {
    private commandClass: Command[] = [];
    private command: Discord.SlashCommandOptionsOnlyBuilder[] = [];

    init(commandClass: Command) {
        this.commandClass.push(commandClass);
        commandClass.command().forEach((command) => {
            this.command.push(command);
        });
    }

    setting(guild_id: string) {
        const rest = new Discord.REST().setToken(process.env.TOKEN as string);

        rest.put(Discord.Routes.applicationGuildCommands(process.env.CLIENT_ID as string, guild_id), {
            body: this.command.map(command => command.toJSON())
        }).then(() => console.log("슬레시 명령어 등록 완료")).catch(console.error);
    }

    async run(inte: Inte) {
        for (let commandClass of this.commandClass) {
            if (await commandClass.run(inte)) {
                break;
            }
        }
    }
}