import * as Discord from 'discord.js';
import "dotenv/config";
import path from 'path';
import fs from 'fs';
import { init } from './init';
import { user_regist } from './client/command/registration';
import { User_regist } from './type';
import { memberAdd } from './client/dynamic/memberAdd';
const { Guilds, GuildMessages, MessageContent, GuildMessageReactions, GuildMembers, GuildVoiceStates } = Discord.GatewayIntentBits;
const { Message, Channel, Reaction, GuildMember } = Discord.Partials;
const client = new Discord.Client({ 
    intents: [Guilds, GuildMessages, MessageContent, GuildMessageReactions, GuildMembers, GuildVoiceStates],
    partials: [Message, Channel, Reaction, GuildMember ],
});
export type Inte = Discord.Interaction<Discord.CacheType>;
export const reg_db_path = path.join(__dirname, "../db/registration.json");

const bot = init();

client.once('ready', () => {
    client.guilds.cache.forEach((guild) => {
        bot.setting(guild.id);
    });

    const reg = JSON.parse(fs.readFileSync(reg_db_path).toString()) as [string, User_regist][];
    reg.forEach((data) => {
        user_regist.set(data[0], data[1]);
    });

    console.log(client.user?.tag+ "봇 준비 완료");
});

client.on("interactionCreate", (inte) => {
    bot.run(inte);
});

client.on("guildMemberAdd", (member) => {
    memberAdd(member);
});

client.login(process.env.TOKEN);