import * as Discord from "discord.js";
import { Command } from "../../setting";
import { Inte } from "../../main";

export default class Rename implements Command {
    private channel = "1281257893185847406";

    command() {
        return [
            new Discord.SlashCommandBuilder().setName("별명변경").setDescription("유저의 별명을 변경합니다")
            .addStringOption(option =>
                option.setName("nickname")
                .setDescription("별명을 적어주세요")
                .setRequired(true)
            )
        ]
    }

    async run(inte:Inte) {
        let result = false;
        if(inte.isCommand()) {
            if(inte.commandName == "별명변경") {
                result = true;
                if(inte.channelId == this.channel) {
                    const nickname = inte.options.get("nickname")?.value as string;
                    if(nickname.length <= 7) {
                        const member = inte.guild?.members.cache.get(inte.user.id);
                        
                        const rename = member?.nickname?.replace(/(?<=◟+.+꒱)(.+)(?=₊ ˚ ଓ)/, (match, name:string) => {
                            const embed = new Discord.EmbedBuilder()
                            .setTitle(name.trim()+"님 별명 변경")
                            .setDescription(name.trim()+"님 별명이 "+nickname+"로 변경되었습니다");
                            inte.reply({embeds: [embed]});
                            
                            return match.replace(name, " "+nickname+" ");
                        }) as string;
                        await member?.setNickname(rename);
                    }else {
                        await inte.reply({
                            content: "별명은 7글자 이하로 설정해주세요",
                            ephemeral: true
                        });
                    }
                }else {
                    await inte.reply({
                        content: "이 명령어는 "+Discord.channelMention(this.channel)+"에서만 사용 가능합니다",
                        ephemeral: true
                    });
                }
            }
        }
        return result;
    }
}