import * as Discord from "discord.js";
import fs from "fs";
import { User_regist } from "../../type";
import { Command } from "../../setting";
import { Inte, reg_db_path } from "../../main";
export const user_regist = new Map<string, User_regist>();

export default class Registration implements Command {
    private channel = "1281257892783198257";
    private channel_log = "1281257892783198255";

    command() {
        return [
            new Discord.SlashCommandBuilder().setName("발급받기").setDescription("우리 서버의 일원이 되고 싶다면 자기소개를 해주세요")
            .addStringOption(option =>
                option.setName("이름")
                .setDescription("사용자 이름")
                .setRequired(true)
            ).addStringOption(option =>
                option.setName("나이")
                .setDescription("나이 연도로 적어주세요")
                .addChoices([
                    { name: "11년", value:"11" },
                    { name: "10년", value:"10" },
                    { name: "09년", value:"09" },
                    { name: "08년", value:"08" },
                    { name: "07년", value:"07" },
                    { name: "06년", value:"06" },
                    { name: "05년", value:"05" },
                    { name: "04년", value:"04" },
                    { name: "03년", value:"03" },
                    { name: "02년", value:"02" },
                    { name: "01년", value:"01" },
                    { name: "00년", value:"00" },
                    { name: "99년", value:"99" },
                    { name: "98년", value:"98" },
                    { name: "97년", value:"97" },
                    { name: "96년", value:"96" },
                    { name: "95년", value:"95" },
                    { name: "94년", value:"94" },
                    { name: "93년", value:"93" },
                    { name: "92년", value:"92" },
                    { name: "91년", value:"91" },
                ]).setRequired(true)
            ).addStringOption(option =>
                option.setName("비공여부")
                .setDescription("나이 비공 여부")
                .addChoices([
                    { name: "비공개", value: "null" },
                    { name: "공개", value: "공개" }
                ]).setRequired(true)
            ).addStringOption(option =>
                option.setName("성별")
                .setDescription("자신의 성별")
                .addChoices([
                    { name: "남성", value: "남" },
                    { name: "여성", value: "여" }
                ]).setRequired(true)
            ).addStringOption(option =>
                option.setName("경로")
                .setDescription("들어온 경로를 입력해주세요")
                .addChoices([
                    { name: "디스보드", value: "디스보드" },
                    { name: "디코올", value: "디코올" },
                    { name: "지인 초대", value: "지인 초대" },
                    { name: "연합 서버", value: "연합" },
                    { name: "부계", value: "부계" }
                ]).setRequired(true)
            ).addStringOption(option =>
                option.setName("지인_초대")
                .setDescription("초대 받은 경우 초대 받은 사람의 이름을 적어주세요")
            )
        ]
    }

    async run(inte:Inte) {
        let result = false;
        if(inte.isCommand()) {
            if(inte.commandName == "발급받기") {
                result = true;
                if(inte.channelId != this.channel) {
                    await inte.reply({
                        content:"발급을 받고 샆다면 "+Discord.channelMention(this.channel)+"에서만 가능합니다",
                        ephemeral:true
                    });
                    return result;
                }
                const name = inte.options.get("이름")?.value as string;
                const age = inte.options.get("나이")?.value as string;
                const age_is = inte.options.get("비공여부")?.value as string;
                const gender = inte.options.get("성별")?.value as string;
                const path = inte.options.get("경로")?.value as string;
                const invite = inte.options.get("지인_초대")?.value as string | null;

                if(name.length > 7) {
                    await inte.reply({
                        content:"이름은 7글자 이하로 적어주세요",
                        ephemeral:true
                    });
                    return result;
                }

                if(!invite && path == "지인 초대") {
                    await inte.reply({
                        content:"초대 받은 경우 초대 받은 사람의 이름을 적어주세요",
                        ephemeral:true
                    });
                    return result;
                }

                var age_is_val = false;
                if(age_is != "null") {
                    age_is_val = true;
                }

                var year = "20"
                if(age[0] == "9") {
                    year = "19";
                }
                year += age;
                const now = (new Date().getFullYear() - Number(year))+1;
                const age_now = now+"세";
                
                user_regist.set(inte.user.id, {
                    name: name,
                    age: now,
                    age_is: age_is_val,
                    gender: gender,
                    path: path,
                    invite: invite ? invite : null
                });
                
                const embed = new Discord.EmbedBuilder()
                .setTitle("자기소개 완료")
                .setImage(inte.user.avatarURL())
                .setDescription("<a:check:1281982561744326707>")
                .setFields([
                    { name: " ", value:"<a:menu_1:1281982689368608831> "+Discord.channelMention("1281257893034721330")+"에서 경로인증 후"},
                    { name: " ", value:"<a:menu_2:1281982728442613763> "+Discord.channelMention("1281257893034721332")+"채널에서 "+Discord.roleMention("1281257891105341458")+"를 멘션해주세요"},
                    { name: " ", value:"<a:menu_3:1281982773221134397> 발급이 끝나면 자동으로 역할이 부여됩니다"}
                ]);

                await (inte.channel as Discord.TextChannel).send({embeds:[embed]});
                await inte.reply({content:"자기소개가 완료되었습니다", ephemeral:true});
                const channel = inte.guild?.channels.cache.get(this.channel_log) as Discord.TextChannel;
                const member = inte.guild?.members.cache.get(inte.user.id);
                const time_pos = member?.joinedAt?.getTime();
                var str_pos = "";
                if(!time_pos) {
                    str_pos = "알수없음";
                }else {
                    str_pos = "<t:"+Math.floor(time_pos / 1000)+":D>";
                }
                const embed_2 = new Discord.EmbedBuilder()
                .setTitle("새 유저 "+inte.user.username+ "님이 서버에 자기소개를 마치셨습니다")
                .setDescription(inte.user.id)
                .setImage(inte.user.avatarURL())
                .setFields([
                    { name: "이름", value: name, inline:true },
                    { name: "나이", value: age_now, inline:true },
                    { name: "비공개 여부" , value: age_is_val ? "공개" : "비공개", inline:true },
                    { name: "성별", value: gender, inline:true },
                    { name: "경로", value: path, inline:true },
                    { name: "초대한 사람", value: invite ? invite : "없음", inline:true },
                    { name: " ", value: " " },
                    { name: "유저 정보", value: " ", },
                    { name: "유저 id", value: inte.user.id, inline:true },
                    { name: "유저 생성일", value: "<t:"+Math.floor(inte.user.createdAt.getTime() / 1000)+":R>", inline:true },
                    { name: "유저 입장일", value: str_pos , inline:true }
                ]);

                const row = new Discord.ActionRowBuilder<Discord.ButtonBuilder>();
                row.addComponents(
                    new Discord.ButtonBuilder()
                    .setCustomId("reg_accept")
                    .setLabel("수락")
                    .setStyle(Discord.ButtonStyle.Success)
                    .setEmoji("✅"),

                    new Discord.ButtonBuilder()
                    .setCustomId("reg_reject")
                    .setLabel("거절")
                    .setStyle(Discord.ButtonStyle.Danger)
                    .setEmoji("❌")
                );

                await channel.send({embeds:[embed_2], components:[row]});
                fs.writeFileSync(reg_db_path, JSON.stringify(Array.from(user_regist.entries())));
            }
        }else if(inte.isButton()) {
            if(inte.customId == "reg_accept") {
                result = true;
                const user_id = inte.message.embeds[0].description as string;
                const user = inte.guild?.members.cache.get(user_id);
                const user_reg = user_regist.get(user_id);

                const name = user_reg?.name as string;
                const age = user_reg?.age as number;
                const age_is = user_reg?.age_is as boolean;
                const gender = user_reg?.gender as string;
                const path = user_reg?.path as string;
                const invite = user_reg?.invite as string | null;
                const time = user?.user.createdAt?.getTime();
                const time_pos = user?.joinedAt?.getTime();

                if(age_is) {
                    if(age < 20) {
                        await user?.roles.add("1281257891159867454"); // 10세
                    }else if(age < 30) {
                        await user?.roles.add("1281257891159867453"); // 20세
                    }
                }else {
                    await user?.roles.add("1281257891139031152"); // 비공개
                }

                var str_time = "";
                var str_pos = "";
                if(!time) {
                    str_time = "알수없음";
                }else {
                    str_time = "<t:"+Math.floor(time / 1000)+":R>";
                }
                if(!time_pos) {
                    str_pos = "알수없음";
                }else {
                    str_pos = "<t:"+Math.floor(time_pos / 1000)+":D>";
                }

                const embed = new Discord.EmbedBuilder()
                .setTitle("뉴페 기록")
                .setColor("#00FF00")
                .setAuthor({ name: "안내원: "+inte.user.username, iconURL: inte.user.avatarURL() as string })
                .setThumbnail(user?.user.avatarURL() as string)
                .setFields([
                    { name: "이름", value: name, inline:true },
                    { name: "나이", value: age + "세", inline:true },
                    { name: "비공개 여부" , value: age_is ? "공개" : "비공개", inline:true },
                    { name: "성별", value: gender, inline:true },
                    { name: "경로", value: path, inline:true },
                    { name: "초대한 사람", value: invite ? invite : "없음", inline:true },
                    { name: " ", value: "유저 정보", },
                    { name: "유저 id", value: user_id, inline:true },
                    { name: "유저 생성일", value: str_time,  inline:true },
                    { name: "유저 입장일", value: str_pos, inline:true }
                ]);

                await inte.update({embeds:[embed], components:[]});

                await user?.setNickname("◟신입손님꒱ "+name+" ₊ ˚ ଓ");

                if(gender == "남") {
                    await user?.roles.add("1281257891159867456"); // 남성
                }else if(gender == "여") {
                    await user?.roles.add("1281257891159867455"); // 여성
                }
                await user?.roles.add("1281257891159867458");
                await user?.roles.add("1281257891159867457");
                await user?.roles.remove("1281257891189489674");

                // if(path == "연합") {
                //     await user?.roles.add("1272058217815343146"); // 전학생
                // }

                user_regist.delete(user_id);
                fs.writeFileSync(reg_db_path, JSON.stringify(Array.from(user_regist.entries())));
            }else if(inte.customId == "reg_reject") {
                result = true;
                const user_id = inte.message.embeds[0].description as string;
                const user_reg = user_regist.get(user_id);
                const user = inte.guild?.members.cache.get(user_id);

                const time = user?.user.createdAt?.getTime();
                const time_pos = user?.joinedAt?.getTime();
                var str_time = "";
                var str_pos = "";
                if(!time) {
                    str_time = "알수없음";
                }else {
                    str_time = "<t:"+Math.floor(time / 1000)+":R>";
                }
                if(!time_pos) {
                    str_pos = "알수없음";
                }else {
                    str_pos = "<t:"+Math.floor(time_pos / 1000)+":D>";
                }

                const embed = new Discord.EmbedBuilder()
                .setTitle("뉴페 거절")
                .setColor("#FF0000")
                .setAuthor({ name: "안내원: "+inte.user.username, iconURL: inte.user.avatarURL() as string })
                .setThumbnail(user?.user.avatarURL() as string)
                .setFields([
                    { name: "이름", value: user_reg?.name as string, inline:true },
                    { name: "나이", value: user_reg?.age + "세", inline:true },
                    { name: "비공개 여부" , value: user_reg?.age_is ? "공개" : "비공개", inline:true },
                    { name: "성별", value: user_reg?.gender as string, inline:true },
                    { name: "경로", value: user_reg?.path as string, inline:true },
                    { name: "초대한 사람", value: user_reg?.invite ? user_reg?.invite : "없음", inline:true },
                    { name: " ", value: "유저 정보", },
                    { name: "유저 id", value: user_id, inline:true },
                    { name: "유저 생성일", value: str_time,  inline:true },
                    { name: "유저 입장일", value: str_pos, inline:true }
                ]);
                await user?.kick();

                await inte.update({embeds:[embed], components:[]});
                user_regist.delete(user_id);
                fs.writeFileSync(reg_db_path, JSON.stringify(Array.from(user_regist.entries())));
            }
        }
        return result;
    }
}