import * as Discord from 'discord.js';
import { Command } from '../../../setting';
import { Inte } from '../../../main';

export default class Admin implements Command {
    command() {
        return [
            new Discord.SlashCommandBuilder().setName("환영").setDescription("환영 메서지를 보냅니다")
            .addUserOption(option =>
                option.setName("user")
                .setDescription("환영 메시지를 보낼 유저")
                .setRequired(true)
            ).setDefaultMemberPermissions(Discord.PermissionFlagsBits.ManageMessages),

            new Discord.SlashCommandBuilder().setName("메서지청소").setDescription("메시지를 청소합니다")
            .addIntegerOption(option =>
                option.setName("count")
                .setDescription("청소할 메시지 개수")
                .setRequired(true)
            ).setDefaultMemberPermissions(Discord.PermissionFlagsBits.Administrator)
        ]
    }

    async run(inte:Inte) {
        let result = false;
        if(inte.isCommand()) {
            if(inte.commandName === "환영") {
                result = true;
                const user = inte.options.get("user")?.user;
                const mess_str = `
｡☆✼★━━━━━━━━━━━━★✼☆｡

${Discord.userMention(user?.id as string)} 님 𝐒𝐢𝐦𝐩𝐥𝐞 𝐋𝐢𝐛𝐫𝐚𝐫𝐲 서버에 오신 것을 환영 합니다 !

활동 하시기 전에 잠깐!!<a:VA_00:1281862056047542282> 

<a:B2:1281279904670814259> ${Discord.channelMention("1281257893185847402")} 을 꼭 읽어주세요 규칙은 서버 활동 시 꼭 지켜야 할 항목입니다 숙지 부탁드려요!

<a:B2:1281279907434860546> ${Discord.channelMention("1281257893185847404")} 궁금하신 점 또는 건의하실 사항이 있으시다면 문의함을 이용해 주세요!

<a:B2:1281279910924783627> ${Discord.channelMention("1281257893907402883")} 서버에 문제가 생길시 신고박스를 이용해 주세요!

<a:emoji_161:1281928126695346207> ${Discord.channelMention("1281257893185847405")} 에서 필요한 역할을 받으시면 됩니다! 

서버에서 좋은 추억 되세요~!

|| ${Discord.roleMention("1281257891118055528")} ||`
                await (inte.channel as Discord.TextChannel).send(mess_str);
                await inte.reply({content: "환영 메시지를 보냈습니다", ephemeral: true});
            }else if(inte.commandName === "메서지청소") {
                result = true;
                const count = inte.options.get("count")?.value as number;
                const messages = await (inte.channel as Discord.TextChannel).messages.fetch({limit: count});
                await (inte.channel as Discord.TextChannel).bulkDelete(messages);
                await inte.reply({content: `${count}개의 메시지를 삭제했습니다`, ephemeral: true});
            }
        }
        return result;
    }
}