import * as Discord from 'discord.js';
import { Command } from '../../../setting';
import { Inte } from '../../../main';

export default class Blacklist implements Command {
    private channel = "1281257893907402885";

    command() {
        return [
            new Discord.SlashCommandBuilder().setName("블랙리스트").setDescription("유저를 블랙리스트에 추가또는 제거합니다")
            .setDefaultMemberPermissions(Discord.PermissionFlagsBits.Administrator)
        ]
    }

    async run(inte:Inte) {
        let result = false;
        if(inte.isCommand()) {
            if(inte.commandName == "블랙리스트") {
                result = true;
                const embed = new Discord.EmbedBuilder()
                .setTitle("블랙리스트 패널")
                .setDescription("유저를 블랙리스트에 추가 또는 제거합니다");

                const row = new Discord.ActionRowBuilder<Discord.ButtonBuilder>();

                row.addComponents(
                    new Discord.ButtonBuilder()
                    .setCustomId("blacklist_add")
                    .setLabel("블랙리스트 추가")
                    .setStyle(Discord.ButtonStyle.Primary),
                    
                    new Discord.ButtonBuilder()
                    .setCustomId("blacklist_remove")
                    .setLabel("블랙리스트 제거")
                    .setStyle(Discord.ButtonStyle.Danger)
                );

                await inte.reply({embeds:[embed], components: [row], ephemeral: true});
            }
        }else if(inte.isUserSelectMenu()) {
            if(inte.customId === "blacklist_add_user") {
                result = true;
                const id = inte.values[0];
                const member = await inte.guild?.members.fetch(id);
                
                if(member) {
                    const embed = new Discord.EmbedBuilder()
                    .setDescription(id);
                    
                    const row = new Discord.ActionRowBuilder<Discord.ButtonBuilder>();
                    row.addComponents(
                        new Discord.ButtonBuilder()
                        .setLabel("블랙 사유 입력")
                        .setCustomId("blacklist_add_id_modal")
                        .setStyle(Discord.ButtonStyle.Primary)
                    );
                    
                    await inte.update({embeds:[embed], components: [row], content: "블랙리스트 사유 입력"});
                }
            }
        }else if(inte.isButton()) {
            result = await this.button(inte);
        }else if(inte.isModalSubmit()) {
            result = await this.modal(inte);
        }
        return result;
    }

    async button(inte:Discord.ButtonInteraction) {
        let result = false;
        if(inte.customId === "blacklist_add") {
            result = true;
            const embed = new Discord.EmbedBuilder()
            .setTitle("블랙리스트에 추가할 유저를 선택하거나 유저의 아이디를 입력해주세요")
            .setColor("#FF0000");
            
            const row_user = new Discord.ActionRowBuilder<Discord.UserSelectMenuBuilder>();
            const row_btn = new Discord.ActionRowBuilder<Discord.ButtonBuilder>();
            
            row_user.addComponents(
                new Discord.UserSelectMenuBuilder()
                .setCustomId("blacklist_add_user")
                .setPlaceholder("유저를 선택")
                .setMinValues(1)
                .setMaxValues(1)
            );
            
            row_btn.addComponents(
                new Discord.ButtonBuilder()
                .setCustomId("blacklist_add_id_modal")
                .setLabel("아이디 및 사유 입력")
                .setStyle(Discord.ButtonStyle.Primary)
            );
            
            await inte.update({embeds:[embed], components: [row_user, row_btn]});
        }else if(inte.customId === "blacklist_remove") {
            result = true;
            const embed = new Discord.EmbedBuilder()
            .setTitle("블랙리스트 제거")
            .setDescription("블랙리스트에서 제거할 유저를 선택해주세요")
            .setColor("#FF0000");
            
            const row = new Discord.ActionRowBuilder<Discord.ButtonBuilder>();

            row.addComponents(
                new Discord.ButtonBuilder()
                .setCustomId("blacklist_remove_user")
                .setLabel("유저 id 입력")
                .setStyle(Discord.ButtonStyle.Primary)
            );
            
            await inte.update({embeds:[embed], components: [row]});
        }else if(inte.customId === "blacklist_add_id_modal") {
            result = true;
            const id = inte.message.embeds[0].description;

            const modal = new Discord.ModalBuilder()
            .setTitle("블랙리스트 추가")
            .setCustomId("blacklist_add_id_modal");

            const row_1 = new Discord.ActionRowBuilder<Discord.TextInputBuilder>();
            const input = new Discord.TextInputBuilder()
            .setLabel("유저 아이디")
            .setCustomId("blacklist_add_id_input")
            .setPlaceholder("유저 아이디를 입력해주세요")
            .setStyle(Discord.TextInputStyle.Short)
            .setRequired(true);

            if(id) input.setValue(id);
            row_1.addComponents(input);

            const row_2 = new Discord.ActionRowBuilder<Discord.TextInputBuilder>();
            row_2.addComponents(
                new Discord.TextInputBuilder()
                .setLabel("사유")
                .setCustomId("blacklist_add_reason_input")
                .setPlaceholder("블랙리스트 추가 사유를 입력해주세요")
                .setStyle(Discord.TextInputStyle.Paragraph)
                .setRequired(true)
            );

            modal.addComponents(row_1, row_2);
            await inte.showModal(modal);
        }else if(inte.customId === "blacklist_remove_user") {
            result = true;
            const modal = new Discord.ModalBuilder()
            .setTitle("블랙리스트 제거")
            .setCustomId("blacklist_remove_id_modal");

            const row = new Discord.ActionRowBuilder<Discord.TextInputBuilder>();
            row.addComponents(
                new Discord.TextInputBuilder()
                .setLabel("유저 아이디")
                .setCustomId("blacklist_remove_id_input")
                .setPlaceholder("블랙리스트에서 제거할 유저의 아이디를 입력해주세요")
                .setStyle(Discord.TextInputStyle.Short)
                .setRequired(true)
            );
            modal.addComponents(row);

            await inte.showModal(modal);
        }
        return result;
    }

    async modal(inte:Discord.ModalSubmitInteraction) {
        let result = false;
        if(inte.customId === "blacklist_add_id_modal") {
            result = true;
            const id = inte.components[0].components[0].value as string;
            const reason = inte.components[1].components[0].value as string;
            const user = await inte.client.users.fetch(id);

            if(user) {
                const channel = inte.guild?.channels.cache.get(this.channel) as Discord.TextChannel;

                const embed = new Discord.EmbedBuilder()
                .setTitle("블랙리스트 추가 완료")
                .setAuthor({ name: inte.user.username, iconURL: inte.user.avatarURL() as string })
                .setDescription(`${user.displayName}님을 블랙리스트에 추가했습니다`)
                .setFields([
                    { name: "유저 아이디", value: user.id, inline: true },
                    { name: "유저네임", value: user.username, inline: true },
                    { name: "계정 생성일", value: user.createdAt.toLocaleDateString(), inline: true },
                    { name: "사유", value: reason }
                ])
                .setTimestamp()
                .setImage(user.avatarURL() as string)
                .setColor("#FF0000");

                await inte.reply({content:"블랙리스트 추가 완료!!", ephemeral: true});
                await channel.send({embeds: [embed]});
                await inte.guild?.bans.create(user, {reason: reason});
            }else {
                await inte.reply({content: "유저를 찾을 수 없습니다", ephemeral: true});
            }
        }else if(inte.customId === "blacklist_remove_id_modal") {
            result = true;
            const id = inte.components[0].components[0].value as string;
            const user = await inte.client.users.fetch(id);
            if(user) {
                const channel = inte.guild?.channels.cache.get(this.channel) as Discord.TextChannel;

                const embed = new Discord.EmbedBuilder()
                .setTitle("블랙리스트 제거 완료")
                .setAuthor({ name: inte.user.username, iconURL: inte.user.avatarURL() as string })
                .setDescription(`${user.username}님을 블랙리스트에서 제거했습니다`)
                .setThumbnail(user.avatarURL() as string)
                .setTimestamp()
                .setColor("#00FF00");

                await inte.reply({content:"블랙리스트 제거 완료!!", ephemeral: true});
                await channel.send({embeds: [embed]});
                await inte.guild?.bans.remove(user);
            }    
        }
        return result;
    }
}