"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const Discord = __importStar(require("discord.js"));
class Blacklist {
    constructor() {
        this.channel = "1281257893907402885";
    }
    command() {
        return [
            new Discord.SlashCommandBuilder().setName("블랙리스트").setDescription("유저를 블랙리스트에 추가또는 제거합니다")
                .setDefaultMemberPermissions(Discord.PermissionFlagsBits.Administrator)
        ];
    }
    run(inte) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            let result = false;
            if (inte.isCommand()) {
                if (inte.commandName == "블랙리스트") {
                    result = true;
                    const embed = new Discord.EmbedBuilder()
                        .setTitle("블랙리스트 패널")
                        .setDescription("유저를 블랙리스트에 추가 또는 제거합니다");
                    const row = new Discord.ActionRowBuilder();
                    row.addComponents(new Discord.ButtonBuilder()
                        .setCustomId("blacklist_add")
                        .setLabel("블랙리스트 추가")
                        .setStyle(Discord.ButtonStyle.Primary), new Discord.ButtonBuilder()
                        .setCustomId("blacklist_remove")
                        .setLabel("블랙리스트 제거")
                        .setStyle(Discord.ButtonStyle.Danger));
                    yield inte.reply({ embeds: [embed], components: [row], ephemeral: true });
                }
            }
            else if (inte.isUserSelectMenu()) {
                if (inte.customId === "blacklist_add_user") {
                    result = true;
                    const id = inte.values[0];
                    const member = yield ((_a = inte.guild) === null || _a === void 0 ? void 0 : _a.members.fetch(id));
                    if (member) {
                        const embed = new Discord.EmbedBuilder()
                            .setDescription(id);
                        const row = new Discord.ActionRowBuilder();
                        row.addComponents(new Discord.ButtonBuilder()
                            .setLabel("블랙 사유 입력")
                            .setCustomId("blacklist_add_id_modal")
                            .setStyle(Discord.ButtonStyle.Primary));
                        yield inte.update({ embeds: [embed], components: [row], content: "블랙리스트 사유 입력" });
                    }
                }
            }
            else if (inte.isButton()) {
                result = yield this.button(inte);
            }
            else if (inte.isModalSubmit()) {
                result = yield this.modal(inte);
            }
            return result;
        });
    }
    button(inte) {
        return __awaiter(this, void 0, void 0, function* () {
            let result = false;
            if (inte.customId === "blacklist_add") {
                result = true;
                const embed = new Discord.EmbedBuilder()
                    .setTitle("블랙리스트에 추가할 유저를 선택하거나 유저의 아이디를 입력해주세요")
                    .setColor("#FF0000");
                const row_user = new Discord.ActionRowBuilder();
                const row_btn = new Discord.ActionRowBuilder();
                row_user.addComponents(new Discord.UserSelectMenuBuilder()
                    .setCustomId("blacklist_add_user")
                    .setPlaceholder("유저를 선택")
                    .setMinValues(1)
                    .setMaxValues(1));
                row_btn.addComponents(new Discord.ButtonBuilder()
                    .setCustomId("blacklist_add_id_modal")
                    .setLabel("아이디 및 사유 입력")
                    .setStyle(Discord.ButtonStyle.Primary));
                yield inte.update({ embeds: [embed], components: [row_user, row_btn] });
            }
            else if (inte.customId === "blacklist_remove") {
                result = true;
                const embed = new Discord.EmbedBuilder()
                    .setTitle("블랙리스트 제거")
                    .setDescription("블랙리스트에서 제거할 유저를 선택해주세요")
                    .setColor("#FF0000");
                const row = new Discord.ActionRowBuilder();
                row.addComponents(new Discord.ButtonBuilder()
                    .setCustomId("blacklist_remove_user")
                    .setLabel("유저 id 입력")
                    .setStyle(Discord.ButtonStyle.Primary));
                yield inte.update({ embeds: [embed], components: [row] });
            }
            else if (inte.customId === "blacklist_add_id_modal") {
                result = true;
                const id = inte.message.embeds[0].description;
                const modal = new Discord.ModalBuilder()
                    .setTitle("블랙리스트 추가")
                    .setCustomId("blacklist_add_id_modal");
                const row_1 = new Discord.ActionRowBuilder();
                const input = new Discord.TextInputBuilder()
                    .setLabel("유저 아이디")
                    .setCustomId("blacklist_add_id_input")
                    .setPlaceholder("유저 아이디를 입력해주세요")
                    .setStyle(Discord.TextInputStyle.Short)
                    .setRequired(true);
                if (id)
                    input.setValue(id);
                row_1.addComponents(input);
                const row_2 = new Discord.ActionRowBuilder();
                row_2.addComponents(new Discord.TextInputBuilder()
                    .setLabel("사유")
                    .setCustomId("blacklist_add_reason_input")
                    .setPlaceholder("블랙리스트 추가 사유를 입력해주세요")
                    .setStyle(Discord.TextInputStyle.Paragraph)
                    .setRequired(true));
                modal.addComponents(row_1, row_2);
                yield inte.showModal(modal);
            }
            else if (inte.customId === "blacklist_remove_user") {
                result = true;
                const modal = new Discord.ModalBuilder()
                    .setTitle("블랙리스트 제거")
                    .setCustomId("blacklist_remove_id_modal");
                const row = new Discord.ActionRowBuilder();
                row.addComponents(new Discord.TextInputBuilder()
                    .setLabel("유저 아이디")
                    .setCustomId("blacklist_remove_id_input")
                    .setPlaceholder("블랙리스트에서 제거할 유저의 아이디를 입력해주세요")
                    .setStyle(Discord.TextInputStyle.Short)
                    .setRequired(true));
                modal.addComponents(row);
                yield inte.showModal(modal);
            }
            return result;
        });
    }
    modal(inte) {
        var _a, _b, _c, _d;
        return __awaiter(this, void 0, void 0, function* () {
            let result = false;
            if (inte.customId === "blacklist_add_id_modal") {
                result = true;
                const id = inte.components[0].components[0].value;
                const reason = inte.components[1].components[0].value;
                const user = yield inte.client.users.fetch(id);
                if (user) {
                    const channel = (_a = inte.guild) === null || _a === void 0 ? void 0 : _a.channels.cache.get(this.channel);
                    const embed = new Discord.EmbedBuilder()
                        .setTitle("블랙리스트 추가 완료")
                        .setAuthor({ name: inte.user.username, iconURL: inte.user.avatarURL() })
                        .setDescription(`${user.displayName}님을 블랙리스트에 추가했습니다`)
                        .setFields([
                        { name: "유저 아이디", value: user.id, inline: true },
                        { name: "유저네임", value: user.username, inline: true },
                        { name: "계정 생성일", value: user.createdAt.toLocaleDateString(), inline: true },
                        { name: "사유", value: reason }
                    ])
                        .setTimestamp()
                        .setImage(user.avatarURL())
                        .setColor("#FF0000");
                    yield inte.reply({ content: "블랙리스트 추가 완료!!", ephemeral: true });
                    yield channel.send({ embeds: [embed] });
                    yield ((_b = inte.guild) === null || _b === void 0 ? void 0 : _b.bans.create(user, { reason: reason }));
                }
                else {
                    yield inte.reply({ content: "유저를 찾을 수 없습니다", ephemeral: true });
                }
            }
            else if (inte.customId === "blacklist_remove_id_modal") {
                result = true;
                const id = inte.components[0].components[0].value;
                const user = yield inte.client.users.fetch(id);
                if (user) {
                    const channel = (_c = inte.guild) === null || _c === void 0 ? void 0 : _c.channels.cache.get(this.channel);
                    const embed = new Discord.EmbedBuilder()
                        .setTitle("블랙리스트 제거 완료")
                        .setAuthor({ name: inte.user.username, iconURL: inte.user.avatarURL() })
                        .setDescription(`${user.username}님을 블랙리스트에서 제거했습니다`)
                        .setThumbnail(user.avatarURL())
                        .setTimestamp()
                        .setColor("#00FF00");
                    yield inte.reply({ content: "블랙리스트 제거 완료!!", ephemeral: true });
                    yield channel.send({ embeds: [embed] });
                    yield ((_d = inte.guild) === null || _d === void 0 ? void 0 : _d.bans.remove(user));
                }
            }
            return result;
        });
    }
}
exports.default = Blacklist;
